% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_alignment_params.R
\name{create_alignment_params}
\alias{create_alignment_params}
\title{Create the parameters for the alignment simulation.}
\usage{
create_alignment_params(
  root_sequence = pirouette::create_blocked_dna(1000),
  sim_tral_fun = pirouette::sim_tral_with_std_nsm,
  rng_seed = 0,
  fasta_filename = pirouette::get_temp_fasta_filename()
)
}
\arguments{
\item{root_sequence}{the DNA sequence at the root of the phylogeny.
By default, this will consist out of an equal amount of each letter
Use \link{check_root_sequence} to check if a root sequence is valid.}

\item{sim_tral_fun}{function to simulate a
true alignment with.
This function must have two arguments,
called \code{true_phylogeny} (which will hold the true phylogeny)
and \code{root_sequence} (which holds the DNA root sequence).
The return type must be \link[ape]{DNAbin}.

Use \link{check_sim_tral_fun} to verify if the function
has the right signature and output.

Some standard functions:\cr
\itemize{
  \item Use \link{get_sim_tral_with_std_nsm_fun}
  to get a function (\link{sim_tral_with_std_nsm})
  the use a standard site model.
  \item Use
  \link{get_sim_tral_with_lns_nsm_fun}
  to get a function
  (\link{sim_tral_with_lns_nsm})
  the use a linked node substitution site model.
  \item Use
  \link{get_sim_tral_with_uns_nsm_fun}
  to get a function
  (\link{sim_tral_with_uns_nsm})
  the use an unlinked node substitution site model.
}}

\item{rng_seed}{the random number generator seed as used in the
simulation of an alignment}

\item{fasta_filename}{name of a FASTA file.
Use \link{get_alignment_id} to get the ID of the alignment}
}
\value{
a list of alignment parameters
}
\description{
These parameters are used in the \link{create_pir_params} function
}
\examples{
if (beautier::is_on_ci()) {

  # DNA sequence at the root
  n_base_pairs <- 4
  root_sequence <- create_blocked_dna(length = n_base_pairs)

  # Only specify root sequence and mutation rate, use defaults
  alignment_params <- create_alignment_params(
    root_sequence = root_sequence
  )

  # Use defaults explicitly
  alignment_params <- create_alignment_params(
    root_sequence = root_sequence,
    rng_seed = 0
  )

  # Create a pirouette parameter set
  pir_params <- create_test_pir_params(alignment_params = alignment_params)

  # Run pirouette
  if (beautier::is_on_ci() && is_beast2_installed()) {
    pir_out <- pir_run(
      phylogeny = ape::read.tree(text = "((A:1, B:1):1, C:2);"),
      pir_params = pir_params
    )
    pir_plot(pir_out)
  }
}
}
\author{
Richèl J.C. Bilderbeek
}
