% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get.phat.quadratic}
\alias{get.phat.quadratic}
\title{Get the pvalue for the quadratic statistic}
\usage{
get.phat.quadratic(x, y, method = c("is", "nested", "mc", "exact"),
  N.mc = 10^3, N.is = 10^3, N.level = 1000, q = 0.2, B = 5 *
  length(x), mc.cores = 1, do.sd = FALSE)
}
\arguments{
\item{x}{binary vector of treatment assignment}

\item{y}{gene expression measurement matrix}

\item{method}{method to estimate pvalue for the linear statistic}

\item{N.mc}{number of mc samples is method == "mc"}

\item{N.is}{number of mc samples is method == "is"}

\item{N.level}{number of samples in each level if method == "nested"}

\item{q}{progression quantile if method == "nested"}

\item{B}{number of burn-ins to use if method == "nested"}

\item{mc.cores}{number of cores to use in mcapply}

\item{do.sd}{logical to indicate whether calculating sd or not}
}
\value{
a list containing phat from different methods
}
\description{
Get the pvalue for the quadratic statistic
}
\examples{
x <- c(rep(0, 4), rep(1, 4))
y <- matrix(c(rnorm(4*5, 0, 1), rnorm(4*5, 2 ,1)), nrow = 8)
get.phat.quadratic(x, y, method = "is")
get.phat.quadratic(x, y, method = "nested")
get.phat.quadratic(x, y, method = "mc")
get.phat.quadratic(x, y, method = "exact")
get.phat.quadratic(x, y, method = "is", do.sd = TRUE)
get.phat.quadratic(x, y, method = "nested", do.sd = TRUE)
get.phat.quadratic(x, y, method = "mc", do.sd = TRUE)
get.phat.quadratic(x, y, method = "exact", do.sd = TRUE)
}
