% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board.R
\name{board_register}
\alias{board_register}
\title{Register Board}
\usage{
board_register(board, name = board, ...)
}
\arguments{
\item{board}{The name of the board to register.}

\item{name}{An optional name to identify this board, defaults to the board name.}

\item{...}{Additional parameters required to initialize a particular board.}
}
\description{
Registers a board, useful to add sources to \code{pin_find()} or pin to remote
boards with \code{pin()}.
}
\examples{
# create a new local board
board_register("local", "other_board")

# create a Website board
board_register("datatxt", name = "txtexample", url = "https://datatxt.org/data.txt")

}
\seealso{
\code{\link{board_register_github}}, \code{\link{board_register_kaggle}},
  \code{\link{board_register_rsconnect}} and \code{\link{board_register_datatxt}}.
}
