% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pima-.r
\name{pima}
\alias{pima}
\title{Calculating Prediction Intervals}
\usage{
pima(y, se, alpha = 0.05, method = "boot", B = 25000,
  maxit1 = 1e+05, eps = 10^(-10), lower = 0, upper = 1000,
  maxit2 = 1000, tol = .Machine$double.eps^0.25, rnd = NULL,
  maxiter = 100)
}
\arguments{
\item{y}{the effect size estimates vector}

\item{se}{the within studies standard errors vector}

\item{alpha}{the alpha level of the prediction interval}

\item{method}{the calculation method for the pretiction interval (default = "boot").
\itemize{
\item \code{boot}: A parametric bootstrap prediction interval.
\item \code{HTS}: the Higgins--Thompson--Spiegelhalter prediction interval / 
           the DerSimonian & Laird estimator for \eqn{\tau^2} with
           a standard SE estimator for the average effect,
           \eqn{(1/\sum{\hat{w}_i})^{-1}}.
\item \code{HK}: Partlett & Riley's prediction interval /
           the REML estimator for \eqn{\tau^2} with
           the Hartung and Knapp (2001)'s SE estimator for the average effect.
\item \code{SJ}: Partlett & Riley's prediction interval /
           the REML estimator for \eqn{\tau^2} with
           the Sidik and Jonkman (2006)'s bias coreccted SE estimator
            for the average effect.
\item \code{CL}: a prediction interval with REML and standard SE /
           the REML estimator for \eqn{\tau^2} with
           a standard SE estimator for the average effect.
}}

\item{B}{the number of bootstrap samples}

\item{maxit1}{the maximum number of iteration for the exact distribution function of \eqn{Q}}

\item{eps}{the desired level of accuracy for the exact distribution function of \eqn{Q}}

\item{lower}{the lower limit of random numbers of \eqn{\tau^2}}

\item{upper}{the lower upper of random numbers of \eqn{\tau^2}}

\item{maxit2}{the maximum number of iteration for numerical inversions}

\item{tol}{the desired level of accuracy for numerical inversions}

\item{rnd}{a vector of random numbers from the exact distribution of \eqn{\tau^2}}

\item{maxiter}{the maximum number of iteration for REML estimation}
}
\value{
The average treatment effect estimate \eqn{\hat{\mu}} (\code{muhat}),
and the lower and upper prediction limits \eqn{\hat{c}_l} (\code{lbpi}) and \eqn{\hat{c}_u} (\code{ubpi}).
}
\description{
This function calculates prediction intervals using \code{pima_boot},
\code{pima_hts}, or \code{pima_htsreml} functions.
}
\examples{
data(sbp, package = "pimeta")
set.seed(20161102)
\donttest{pimeta::pima(sbp$y, sbp$sigmak, B = 50000)}
# Average treatment effect [95\%PI]:
# -0.3341 [-0.8769, 0.2248]
# Average treatment effect [95\%CI]:
# -0.3341 [-0.5660, -0.0976]
# Heterogeneity variance (tau^2):
# 0.0282

\donttest{pimeta::pima(sbp$y, sbp$sigmak, method = "HTS")}
# Average treatment effect [95\%PI]:
# -0.3341 [-0.7598, 0.0917]
# Average treatment effect [95\%CI]:
# -0.3341 [-0.5068, -0.1613]
# Heterogeneity variance (tau^2):
# 0.0282

\donttest{pimeta::pima(sbp$y, sbp$sigmak, method = "HK")}
# Average treatment effect [95\%PI]:
# -0.3287 [-0.9887, 0.3312]
# Average treatment effect [95\%CI]:
# -0.3287 [-0.5761, -0.0814]
# Heterogeneity variance (tau^2):
# 0.0700

\donttest{pimeta::pima(sbp$y, sbp$sigmak, method = "SJ")}
# Average treatment effect [95\%PI]:
# -0.3287 [-0.9835, 0.3261]
# Average treatment effect [95\%CI]:
# -0.3287 [-0.5625, -0.0950]
# Heterogeneity variance (tau^2):
# 0.0700
}
\references{
Higgins, J. P. T, Thompson, S. G., Spiegelhalter, D. J. (2009).
A re-evaluation of random-effects meta-analysis.
\emph{J R Stat Soc Ser A Stat Soc.}
\strong{172}(1): 137-159.

Partlett, C, and Riley, R. D. (2017).
Random effects meta-analysis: Coverage performance of 95%
confidence and prediction intervals following REML estimation.
\emph{Stat Med.}
\strong{36}(2): 301-317.

Nagashima, K., Noma, H., and Furukawa, T. A. (2018).
Prediction intervals for random-effects meta-analysis:
a confidence distribution approach.
\emph{Stat Methods Med Res}.
\emph{In press}.
\url{https://doi.org/10.1177/0962280218773520}.
}
