% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pii.R
\name{pii}
\alias{pii}
\title{Predictive Information Index (PII)}
\usage{
pii(full_preds, score_preds, type = c("r2", "rm", "v"))
}
\arguments{
\item{full_preds}{Predicted values from the full (benchmark) model.}

\item{score_preds}{Predicted values from the score-based model.}

\item{type}{Type of PII to compute: "r2", "rm", or "v".}
}
\value{
A numeric value between 0 and 1.
}
\description{
Computes the Predictive Information Index using one of three methods:
"r2" (R-squared ratio), "rm" (RMSE-based), or "v" (variance ratio).
}
\examples{
full <- rnorm(100)
score <- full + rnorm(100, sd = 0.5)
pii(full, score, type = "rm")
}
