% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_piece.R
\name{render_piece}
\alias{render_piece}
\title{Render image of game pieces}
\usage{
render_piece(
  df,
  file = NULL,
  ...,
  .f = piecepackr::grid.piece,
  cfg = getOption("piecepackr.cfg", NULL),
  envir = getOption("piecepackr.envir", game_systems("sans")),
  width = NULL,
  height = NULL,
  ppi = 72,
  bg = "white",
  xoffset = NULL,
  yoffset = NULL,
  new_device = TRUE,
  dev = NULL,
  dev.args = list(res = ppi, bg = bg, units = "in"),
  annotate = FALSE,
  annotation_scale = NULL
)
}
\arguments{
\item{df}{A data frame of game piece information with (at least) the
named columns \dQuote{piece_side}, \dQuote{x}, and \dQuote{y}.}

\item{file}{Filename to save animation unless \code{NULL}
in which case it either uses the current graphics device or opens a new device
(depending on \code{new_device} argument).}

\item{...}{Arguments to \code{\link[=pmap_piece]{pmap_piece()}}}

\item{.f}{Low level graphics function to use e.g. \code{\link[=grid.piece]{grid.piece()}}, \code{\link[=piece3d]{piece3d()}}, or \code{\link[=piece]{piece()}}.}

\item{cfg}{A piecepackr configuration list}

\item{envir}{Environment (or named list) of piecepackr configuration lists}

\item{width}{Width of animation (in inches).  Inferred by default.}

\item{height}{Height of animation (in inches).  Inferred by default.}

\item{ppi}{Resolution of animation in pixels per inch.}

\item{bg}{Background color (use \code{"transparent"} for transparent)}

\item{xoffset}{Number to add to the \code{x} column in \code{df}.  Inferred by default.}

\item{yoffset}{Number to add to the \code{y} column in \code{df}.  Inferred by default.}

\item{new_device}{If \code{file} is \code{NULL} should we open up a new graphics device?}

\item{dev}{Graphics device function to use.  If \code{NULL} infer a reasonable choice.}

\item{dev.args}{Additional arguments to pass to \code{dev} (besides \code{filename}, \code{width}, and \code{height}).
Will filter out any names that aren't in \code{formals(dev)}.}

\item{annotate}{If \code{TRUE} or \code{"algebraic"} annotate the plot
with \dQuote{algrebraic} coordinates,
if \code{FALSE} or \code{"none"} don't annotate,
if \code{"cartesian"} annotate the plot with \dQuote{cartesian} coordinates.}

\item{annotation_scale}{Multiplicative factor that scales (stretches) any annotation coordinates.
By default uses \code{attr(df, "scale_factor") \%||\% 1}.}
}
\value{
An invisible list of the dimensions of the image, as a side effect saves a graphic
}
\description{
\code{render_piece()} renders an image of game pieces to a file or graphics device.
It is a wrapper around \code{pmap_piece()} that can auto-size files and graphic devices,
apply axes offsets, annotate coordinates, and set up \code{rayrender} scenes.
}
\examples{
 df_board <- data.frame(piece_side = "board_face", suit = 3, rank = 8,
                        x = 4.5, y = 4.5, stringsAsFactors = FALSE)
 df_w <- data.frame(piece_side = "bit_face", suit = 6, rank = 1,
                    x = rep(1:8, 2), y = rep(1:2, each=8),
                    stringsAsFactors = FALSE)
 df_b <- data.frame(piece_side = "bit_face", suit = 1, rank = 1,
                    x = rep(1:8, 2), y = rep(7:8, each=8),
                    stringsAsFactors = FALSE)
 df <- rbind(df_board, df_w, df_b)
 df$cfg <- "checkers1"

 render_piece(df)
 render_piece(df, op_scale = 0.5, trans = op_transform, annotate = "algrebraic")
 \dontrun{ # Takes a while to render
 if (require(rayrender)) {
   envir3d <- game_systems("sans3d")
   render_piece(df, .f = piece, envir = envir3d,
                op_scale = 0.5, trans = op_transform,
                samples = 300, clamp_value = 1)
 }
 }
}
\seealso{
This function is a wrapper around \code{\link[=pmap_piece]{pmap_piece()}}.
}
