% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Roy_Larocque_2019.R
\name{RoyRF}
\alias{RoyRF}
\title{implements RF prediction interval method in Roy, Larocque 2019. Helper function.}
\usage{
RoyRF(
  formula = NULL,
  train_data = NULL,
  pred_data = NULL,
  num_trees = NULL,
  min_node_size = NULL,
  m_try = NULL,
  keep_inbag = TRUE,
  intervals = TRUE,
  interval_method = "quantile",
  calibrate = FALSE,
  alpha = NULL,
  num_threads = NULL,
  tolerance = NULL,
  step_percent = NULL,
  under = NULL,
  method = NULL,
  max_iter = NULL,
  interval_type = NULL
)
}
\arguments{
\item{formula}{Object of class formula or character describing the model to fit. Interaction terms supported only for numerical variables.}

\item{train_data}{Training data of class data.frame, matrix, dgCMatrix (Matrix) or gwaa.data (GenABEL). Matches ranger() requirements.}

\item{pred_data}{Test data of class data.frame, matrix, dgCMatrix (Matrix) or gwaa.data (GenABEL). Utilizes ranger::predict() to get prediction intervals for test data.}

\item{num_trees}{Number of trees.}

\item{min_node_size}{Minimum number of observations before split at a node.}

\item{m_try}{Number of variables to randomly select from at each split.}

\item{keep_inbag}{Saves matrix of observations and which tree(s) they occur in. Required to be true to generate variance estimates for Ghosal, Hooker 2018 method. *Should not be an option...}

\item{intervals}{Generate prediction intervals or not.}

\item{interval_method}{which prediction interval type to generate. Several outlined in paper; currently only one method implemented.}

\item{calibrate}{calibrate prediction intervals based on out-of-bag performance. Adjusts alpha to get nominal coverage.}

\item{alpha}{Significance level for prediction intervals.}

\item{num_threads}{The number of threads to use in parallel. Default is the current number of cores.}

\item{interval_type}{Type of prediction interval to generate.
Options are \code{method = c("two-sided", "lower", "upper")}. Default is  \code{method = "two-sided"}.}
}
\description{
Currently implemented is the quantile method with BOP intervals. Used inside rfint().
}
\keyword{internal}
