% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_diversity.R
\name{ps_diversity}
\alias{ps_diversity}
\title{Calculate spatial phylogenetic diversity and endemism metrics}
\usage{
ps_diversity(ps, metric = "all", spatial = TRUE)
}
\arguments{
\item{ps}{phylospatial object (created by \code{phylospatial()} or \code{ps_simulate()}).}

\item{metric}{Character vector containing the abbreviation for one or more diversity metrics listed in
the details below. Can also specify \code{"all"} (the default) to calculate all available metrics.}

\item{spatial}{Logical: should the function return a spatial object (TRUE, default) or a matrix (FALSE)?}
}
\value{
A matrix, \code{sf} data frame, or \code{SpatRaster} with a column or layer for each requested diversity metric.
}
\description{
This function calculates a variety of diversity and endemism metrics including Faith's phylogenetic diversity,
Shannon phylogenetic entropy, Simpson phylogentic diversity, relative phylogentic diversity, richness of clades,
richness of terminals (typically species), and versions of all these metrics weighted by endemism (i.e. rarity).
If continuous community data (probabilities or abundances) are provided, they are used in calculations, giving
quantitative versions of the classic binary metrics.
}
\details{
The function calculates the following metrics:
\itemize{
\item TD---Terminal Diversity, i.e. richness of terminal taxa (in many cases these are species): \eqn{\sum_{t}{p_t}}
\item TE---Terminal Endemism, i.e. total endemism-weighted diversity of terminal taxa, a.k.a. "weighted endemism": \eqn{\sum_{t}{p_t r_t^{-1}}}
\item CD---Clade Diversity, i.e. richness of taxa at all levels (equivalent to PD on a cladogram): \eqn{\sum_{b}{p_b}}
\item CE---Clade Endemism, i.e. total endemism-weighted diversity of taxa at all levels (equivalent to PE on a cladrogram): \eqn{\sum_{b}{p_b r_b^{-1}}}
\item PD---Phylogenetic Diversity: \eqn{\sum_{b}{L_b p_b}}
\item PE---Phylogenetic Endemism, i.e. endemism-weighted PD: \eqn{\sum_{b}{L_b p_b r_b^{-1}}}
\item RPD---Relative Phylogenetic Diversity, i.e. branch length of mean resident (equivalent to PD / CR): \eqn{\sum_{b}{L_b p_b} / \sum_{b}{p_b}}
\item RPE---Relative Phylogenetic Endemism, i.e. mean endemism-weighted branch length (equivalent to PE / CE): \eqn{\sum_{b}{L_b p_b r_b^{-1}} / \sum_{b}{p_b r_b^{-1}}}
\item ShPD---Shannon Phylogenetic Diversity, a.k.a. "phylogenetic entropy": \eqn{-\sum_{b}{L_b n_b log(n_b)}}
\item ShPE--Shannon phylogenetic Endemism, an endemism-weighted version of ShPD: \eqn{-\sum_{b}{L_b n_b log(e_b) r_b^{-1}}}
\item SiPD---Simpson Phylogenetic Diversity: \eqn{1 / \sum_{b}{L_b n_b^2}}
\item SiPE---Simpson Phylogenetic Endemism, an endemism-weighted version of SiPD: \eqn{1 / \sum_{b}{L_b r_b^{-1} e_b^2}}
}

where \eqn{b} indexes all taxa including terminals and larger clades; \eqn{t} indexes terminals only; \eqn{p_i} is the occurrence value
(binary, probability, or abundance) of clade/terminal \eqn{i} in a given community; \eqn{L_b} is the
length of the phylogenetic branch segment unique to clade \eqn{b}; and \eqn{r_i} is the sum of \eqn{p_i} across all sites.

For Shannon and Simpson indices, only nonzero elements of \eqn{p_b} are used, \eqn{n_b = p_b / \sum_{b}{p_b L_b}}, and
\eqn{e_b = p_b / \sum_{b}{p_b L_b r_b^{-1}}}.
}
\examples{
ps <- ps_simulate()
div <- ps_diversity(ps)
terra::plot(div)

}
\references{
Faith, D. P. (1992). Conservation evaluation and phylogenetic diversity. Biological Conservation, 61(1), 1-10.

Laffan, S. W., & Crisp, M. D. (2003). Assessing endemism at multiple spatial scales, with an example from the Australian vascular flora.
Journal of Biogeography, 30(4), 511-520.

Rosauer, D. A. N., Laffan, S. W., Crisp, M. D., Donnellan, S. C., & Cook, L. G. (2009). Phylogenetic endemism:
a new approach for identifying geographical concentrations of evolutionary history. Molecular Ecology, 18(19), 4061-4072.

Allen, B., Kon, M., & Bar-Yam, Y. (2009). A new phylogenetic diversity measure generalizing the Shannon index and its
application to phyllostomid bats. The American Naturalist, 174(2), 236-243.

Chao, A., Chiu, C. H., & Jost, L. (2010). Phylogenetic diversity measures based on Hill numbers. Philosophical Transactions
of the Royal Society B: Biological Sciences, 365(1558), 3599-3609.

Mishler, B. D., Knerr, N., González-Orozco, C. E., Thornhill, A. H., Laffan, S. W., & Miller, J. T. (2014).
Phylogenetic measures of biodiversity and neo-and paleo-endemism in Australian Acacia. Nature Communications, 5(1), 4473.

Kling, M. M., Mishler, B. D., Thornhill, A. H., Baldwin, B. G., & Ackerly, D. D. (2019). Facets of phylodiversity: evolutionary
diversification, divergence and survival as conservation targets. Philosophical Transactions of the Royal Society B, 374(1763), 20170397.
}
