% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlogram.R
\name{phyloCorrelogram}
\alias{phyloCorrelogram}
\title{Phylogenetic correlogram}
\usage{
phyloCorrelogram(p4d, trait = names(tdata(p4d)),
  dist.phylo = "patristic", sigma = NULL, n.points = 100,
  ci.bs = 1000, ci.conf = 0.95)
}
\arguments{
\item{p4d}{a \code{phylo4d} object.}

\item{trait}{the traits in the \code{phylo4d} object to use for the correlogram.
Can be a character vector giving the name of the traits or numbers giving the column index
in the table of the data slot of the \code{phylo4d} object.}

\item{dist.phylo}{a matrix of phylogenetic distances or a character string specifying a method to compute it.
See Details.}

\item{sigma}{a numeric value giving the standard deviation of the normal distribution used
to compute the matrix of phylogenetic weights. If \code{NULL} (default),
the function computes a value from the phylogeny.}

\item{n.points}{an integer giving the number of points at which to compute the correlogram's statistics.}

\item{ci.bs}{an integer giving the number of bootstrap replicates for confidence interval estimation.}

\item{ci.conf}{a value between 0 and 1 giving the confidence level of the confidence interval.}
}
\value{
An object of class "\code{phylocorrelogram}".
}
\description{
This function computes a phylogenetic correlogram.
}
\details{
This function computes a correlogram on a continuous scale of phylogenetic distance.
This is achieved by using a collection of specific phylogenetic weights matrices generated
with the "\code{lag-norm}" method of \code{\link{phyloWeights}} and different values of "\code{mu}".

The confidence envelope is computed by bootstrapping.
At each iteration, the autocorrelation is re-estimated after re-standardization of the
matrix of phylogenetic weights.
The nonparametric confidence intervals are computed at each lag by first order normal approximation.
Intervals are constrained between 0 and 1.

If there is one trait, the function computes Moran's I. If there is more than one trait,
the function computes the Mantel's statistic (Oden and Sokal 1986).

If "\code{dist.phylo}" is a character string,
the phylogenetic distance matrix is computed internally
using the function \code{\link[adephylo]{distTips}} from the package \pkg{adephylo}.
See \code{\link[adephylo]{distTips}} for details about the methods.
}
\examples{
\dontrun{
data(navic)
pc <- phyloCorrelogram(navic)
plot(pc)
}
}
\references{
Oden N.L. & Sokal R.R. (1986) Directional Autocorrelation: An Extension of Spatial Correlograms to Two Dimensions. Systematic Zoology 35, 608-617.
}
\seealso{
\code{\link{plot.phylocorrelogram}},
\code{\link[ape]{correlogram.formula}} in \pkg{ape} for correlograms based on taxonomic levels.
}
