% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylopath.R
\name{choice}
\alias{choice}
\title{Extract and estimate an arbitrary model from a phylogenetic path analysis.}
\usage{
choice(phylopath, choice)
}
\arguments{
\item{phylopath}{An object of class \code{phylopath}.}

\item{choice}{A character string of the name of the model to be chosen, or
the index in \code{models}.}
}
\value{
An object of class \code{fitted_DAG}.
}
\description{
Extract and estimate an arbitrary model from a phylogenetic path analysis.
}
\examples{
  candidates <- list(A = DAG(LS ~ BM, NL ~ BM, DD ~ NL),
                     B = DAG(LS ~ BM, NL ~ LS, DD ~ NL))
  p <- phylo_path(candidates, rhino, rhino_tree)
  my_model <- choice(p, "B")
  # Print the best model to see coefficients, se and ci:
  my_model
  # Plot to show the weighted graph:
  plot(my_model)

}

