% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-phybreak.R
\name{get.phybreak}
\alias{get.phybreak}
\alias{get.tree}
\alias{get.parameters}
\alias{get.mcmc}
\alias{get.phylo}
\alias{get.multiPhylo}
\alias{get.seqdata}
\title{Accessing a phybreak object}
\usage{
get.tree(phybreak.object, samplenr = 0)

get.parameters(phybreak.object, samplenr = 0, whichpars = "posterior")

get.mcmc(phybreak.object, thin = 1, nkeep = Inf)

get.phylo(phybreak.object, samplenr = 0, simmap = FALSE)

get.multiPhylo(phybreak.object, thin = 1, nkeep = Inf)

get.seqdata(phybreak.object)
}
\arguments{
\item{phybreak.object}{An object of class \code{phybreak}.}

\item{samplenr}{The posterior tree sample to choose. If \code{samplenr = 0}, the current state is used.}

\item{whichpars}{Which parameters to return. Either a vector with parameter names, or \code{"all"} for all parameters, or 
\code{"posterior"} for parameters for which a posterior is sampled.}

\item{thin}{Thinning interval.}

\item{nkeep}{Number of samples to keep, counting from tail of the chain.}

\item{simmap}{Whether to include class \code{"simmap"} elements (package \pkg{phytools}), colouring the branches
on the tree to indicate hosts. Is used by \code{\link{plotPhylo}}.}
}
\description{
Accessing a phybreak object
}
\section{Functions}{
\itemize{
\item \code{get.tree}: A \code{data.frame} with current (\code{samplenr = 0}) or sampled infectors and infection times.

\item \code{get.parameters}: A named vector with current (\code{samplenr = 0}) or sampled parameter values.

\item \code{get.mcmc}: An object of class \code{"mcmc"} (package \pkg{coda}), with sampled parameters, 
infection times, and infectors.

\item \code{get.phylo}: Returns an object of class \code{\link[ape]{phylo}} ans optionally of class
\code{"simmap"} (package \pkg{phytools}).

\item \code{get.multiPhylo}: Returns an object of class \code{\link[ape]{multiphylo}}.

\item \code{get.seqdata}: The sequence data in class \code{"phyDat"} (package \pkg{phangorn}).
}}

\examples{
#First build a phybreak-object.
simulation <- sim.phybreak(obsize = 5)
MCMCstate <- phybreak(data = simulation)
MCMCstate <- burnin.phybreak(MCMCstate, ncycles = 20)
MCMCstate <- sample.phybreak(MCMCstate, nsample = 50, thin = 2)

get.tree(MCMCstate)
get.parameters(MCMCstate)
codaobject <- get.mcmc(MCMCstate, thin = 2)
plot.phylo(get.phylo(MCMCstate))
get.seqdata(MCMCstate)

#function from package phangorn:
phangorn::parsimony(get.phylo(MCMCstate), get.seqdata(MCMCstate))

tree0 <- get.phylo(MCMCstate)
seqdata <- get.seqdata(MCMCstate)
phangorn::pml(tree0, seqdata, 
              rate = 0.75*get.parameters(MCMCstate)["mu"]) 
logLik(MCMCstate, genetic = TRUE, withinhost = FALSE, 
       sampling = FALSE, generation = FALSE) 
              #should give the same result as 'pml'
}
\references{
\href{http://dx.doi.org/10.1371/journal.pcbi.1005495}{Klinkenberg et al. (2017)} Simultaneous 
  inference of phylogenetic and transmission trees in infectious disease outbreaks. 
  \emph{PLoS Comput Biol}, \strong{13}(5): e1005495.
}
\author{
Don Klinkenberg \email{don@xs4all.nl}
}
