% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreeqc.R
\name{phrSetErrorFileName}
\alias{phrSetErrorFileName}
\title{Set the name of the error file.}
\usage{
phrSetErrorFileName(filename)
}
\arguments{
\item{filename}{the name of the file.}
}
\description{
Sets the name of the error file. The default value is phreeqc.0.err.
}
\examples{

# This example attempts to run a input string, fails and writes
# the error message to the error file (no database is loaded).
phrSetErrorFileOn(TRUE)
phrSetErrorFileName(file.path(tempdir(), "phreeqc.errors"))
input <- c( 
  'SOLUTION 1 Pure water ',
  'EQUILIBRIUM_PHASES 1  ',
  '    Calcite 0 10      '
  )

if (is.null(phrRunString(input))) {
  cat(paste("see ", phrGetErrorFileName(), ".\n", sep = ""))
}

}
\references{
\url{https://water.usgs.gov/water-resources/software/PHREEQC/IPhreeqc.pdf}
}
\seealso{
Other Error: 
\code{\link{phrGetErrorFileName}()},
\code{\link{phrGetErrorFileOn}()},
\code{\link{phrGetErrorStrings}()},
\code{\link{phrGetErrorStringsOn}()},
\code{\link{phrSetErrorFileOn}()},
\code{\link{phrSetErrorStringsOn}()}
}
\concept{Error}
