% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POS_tag_documents.R
\name{POS_tag_documents}
\alias{POS_tag_documents}
\title{POS tag documents}
\usage{
POS_tag_documents(documents, memory = "-Xmx512M")
}
\arguments{
\item{documents}{A vector of strings (one per document).}

\item{memory}{The default amount of memory (512MB) assigned to the NLP
package to POS tag documents is often not enough for large documents, which
can lead to a "java.lang.OutOfMemoryError". The memory argument defaults to
"-Xmx512M" (512MB) in this package, and can be increased if necessary to
accommodate very large documents.}
}
\value{
A list object.
}
\description{
Annotates documents (provided as a character vector with one
entry per document) with pars-of-speech (POS) tags using the openNLP POS
tagger
}
\examples{
\dontrun{
# load data
documents <- quanteda::data_corpus_inaugural

# run tagger
tagged_documents <- POS_tag_documents(documents)
}
}
