% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ppm2pa}
\alias{ppm2pa}
\title{Convert pressure from PPM to Pascals}
\usage{
ppm2pa(ppm, P)
}
\arguments{
\item{ppm}{Pressure value in umol/mol of class \code{units}}

\item{P}{Atmospheric pressure value in kPa of class \code{units}}
}
\value{
Value in Pa of class \code{units}
}
\description{
Convert pressure from PPM to Pascals
}
\details{
\deqn{\mathrm{Press}(kPa) = \mathrm{Press}(ppm) P(kPa)}{Press(kPa) = Press(ppm) P(kPa)}
\deqn{\mathrm{Press}(Pa) = 1000 \mathrm{Press}(kPa)}{Press(Pa) = 1000 Press(kPa)}
}
\examples{

ppm <- set_units(400, "umol/mol")
P <- set_units(101.325, "kPa")
ppm2pa(ppm, P)
}
