% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ir.r
\name{IR}
\alias{IR}
\alias{NIR}
\alias{IRA}
\alias{SWIR}
\alias{IRB}
\alias{SWIR1}
\alias{SWIR2}
\alias{MIR}
\alias{IRC}
\alias{FIR}
\alias{TIR1}
\alias{TIR2}
\title{Constructors of infra-red wavebands}
\usage{
IR(std = "ISO")

NIR(std = "ISO")

IRA(std = "CIE")

SWIR(std = "CIE")

IRB(std = "CIE")

SWIR1(std = "RS")

SWIR2(std = "RS")

MIR(std = "ISO")

IRC(std = "CIE")

FIR(std = "ISO")

TIR1(std = "RS")

TIR2(std = "RS")
}
\arguments{
\item{std}{character string, "ISO", "CIE", or Landsat imagers named
"LandsatRBV", "LandsatMSS", etc., or "RS", for remote sensing wavebands
as defined in the documentation of package 'RStoolbox'.}
}
\value{
a waveband object wavelength defining a wavelength range.
}
\description{
The wavelength limits for \code{std = "RS"} and Landsat imagers have been
taken from R package RStools and NASA and USGS documentation. They are
defined simply as wavelength ranges without considering the spectral
sensitivity of satellite intruments/cameras based on which remote sensing
based indexes are usually calculated. The values for \code{std = "ISO"} are
according to ISO 20473. The values for \code{std = "CIE"} are suggested
values according to Wikipedia, and need verification.
}
\details{
The names NIR, SWIR and TIR are abbreviations of near infra-red, short-wave
infra-red and thermal infra-red, respectively.
}
\examples{
SWIR1()
SWIR1("RS")

}
\seealso{
\code{\link{Far_red}} for wavebands close to the boundary between red
  and infrared regions.

\code{\link{new_waveband}}  \code{\link{waveband}}

Other unweighted wavebands: \code{\link{Blue}},
  \code{\link{Far_red}}, \code{\link{Green}},
  \code{\link{Orange}}, \code{\link{Purple}},
  \code{\link{Red}}, \code{\link{UVA}}, \code{\link{UVB}},
  \code{\link{UVC}}, \code{\link{UV}}, \code{\link{VIS}},
  \code{\link{Yellow}}
}
\concept{unweighted wavebands}
