% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/far.red.r
\name{Far_red}
\alias{Far_red}
\title{Constructor of FR waveband}
\usage{
Far_red(std = "ISO")
}
\arguments{
\item{std}{a character string, defaults to "ISO", as for other colour
definitions, which in this case returns \code{NA}.}
}
\description{
Far-red radiation according to "ISO" (not defined) or as commonly defined in
plant photobiology, "Smith10" (725-735 nm), "Smith20" (720-740 nm), "Inada"
(700-800 nm), "Warrington" (700-850 nm), and "Sellaro" (700-750 nm). No
weighting applied.
}
\examples{
Far_red()
Far_red("ISO")
Far_red("Smith")

}
\seealso{
\code{\link{NIR}} for wavebands close to the boundary between red
  and infrared regions.

\code{\link[photobiology]{waveband}}

Other unweighted wavebands: \code{\link{Blue}},
  \code{\link{Green}}, \code{\link{IR}},
  \code{\link{Orange}}, \code{\link{Purple}},
  \code{\link{Red}}, \code{\link{UVA}}, \code{\link{UVB}},
  \code{\link{UVC}}, \code{\link{UV}}, \code{\link{VIS}},
  \code{\link{Yellow}}
}
