% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-avaspec-csv.r
\name{read_avaspec_csv}
\alias{read_avaspec_csv}
\title{Read \code{.csv} File Saved by Aavnates' Software for AvaSpec.}
\usage{
read_avaspec_csv(file, date = NULL, geocode = NULL, label = NULL,
  tz = NULL, locale = readr::default_locale())
}
\arguments{
\item{file}{character string}

\item{date}{a \code{POSIXct} object, but if \code{NULL} the date stored in
file is used, and if \code{NA} no date variable is added}

\item{geocode}{A data frame with columns \code{lon} and \code{lat}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone used for interpreting times saved in the
file header.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}
}
\value{
A source_spct object.
}
\description{
Reads and parses the header of a processed data file as output by the
program Avaspec and then imports wavelength and spectral irradiance
values. The file header has little useful metadata information.
}
\author{
Pedro J. Aphalo
}
\references{
\url{http://www.r4photobiology.info}
}
\keyword{misc}

