% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.trim.r
\name{trim_spct}
\alias{trim_mspct}
\alias{trim_spct}
\title{Trim (or expand) head and/or tail}
\usage{
trim_spct(spct, range = NULL, low.limit = NULL, high.limit = NULL,
  use.hinges = TRUE, fill = NULL, byref = FALSE,
  verbose = getOption("photobiology.verbose", default = FALSE))

trim_mspct(mspct, range = NULL, low.limit = NULL, high.limit = NULL,
  use.hinges = TRUE, fill = NULL, byref = FALSE,
  verbose = getOption("photobiology.verbose", default = TRUE))
}
\arguments{
\item{spct}{an object of class "generic_spct"}

\item{range}{a numeric vector of length two, or any other object for which
function range() will return two}

\item{low.limit}{shortest wavelength to be kept (defaults to shortest
w.length value)}

\item{high.limit}{longest wavelength to be kept (defaults to longest w.length
value)}

\item{use.hinges}{logical, if TRUE (the default) wavelengths in nm.}

\item{fill}{if fill==NULL then tails are deleted, otherwise tails or s.irrad
are filled with the value of fill}

\item{byref}{logical indicating if new object will be created by reference or
by copy of spct}

\item{verbose}{logical}

\item{mspct}{an object of class "generic_mspct"}
}
\value{
a spectrum of same class as input with its tails trimmed or expanded
}
\description{
Trimming of head and tail of a spectrum based on wavelength limits,
interpolating the values at the boundaries. Trimming is needed for example to
remove short wavelength noise when the measured spectrum extends beyond the
known emission spectrum of the measured light source. Occasionally one may
want also to expand the wavelength range.
}
\note{
When expanding an spectrum, if fill==NULL, then expansion is not
  performed. Range can be "waveband" object, a numeric vector or a list of
  numeric vectors, or any other user-defined or built-in object for which
  \code{range()} returns a numeric vector of legth two, that can be
  interpreted as wavelengths expressed in nm.
}
\examples{
trim_spct(sun.spct, low.limit=300)
trim_spct(sun.spct, low.limit=300, fill=NULL)
trim_spct(sun.spct, low.limit=300, fill=NA)
trim_spct(sun.spct, low.limit=300, fill=0.0)
trim_spct(sun.spct, range = c(300, 400))
trim_spct(sun.spct, range = c(300, NA))
trim_spct(sun.spct, range = c(NA, 400))
}
\seealso{
Other trim functions: \code{\link{clip_wl}},
  \code{\link{trim_tails}}, \code{\link{trim_waveband}},
  \code{\link{trim_wl}}
}

