% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.methods.R, R/spct.summaries.r, R/waveband.class.r
\name{spread.generic_mspct}
\alias{spread}
\alias{spread.default}
\alias{spread.generic_mspct}
\alias{spread.generic_spct}
\alias{spread.numeric}
\alias{spread.waveband}
\title{Length of object in wavelength units}
\usage{
\method{spread}{generic_mspct}(x, ..., idx = !is.null(names(x)))

\method{spread}{generic_spct}(x, ...)

spread(x, ...)

\method{spread}{default}(x, ...)

\method{spread}{numeric}(x, ...)

\method{spread}{waveband}(x, ...)
}
\arguments{
\item{x}{an R object}

\item{...}{not used in current version}

\item{idx}{logical whether to add a column with the names of the elements of spct}
}
\value{
A numeric value equal to max(x) - min(x). In the case of spectral
  objects wavelength difference in nm. For any other R object, according to
  available definitions of \code{\link{min}} and \code{\link{max}}.
}
\description{
A function that returns the spread (max(x) - min(x)) for R objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{generic_mspct}: Method for "generic_mspct" objects.

\item \code{generic_spct}: Method for "generic_spct" objects.

\item \code{default}: Default method for generic function

\item \code{numeric}: Default method for generic function

\item \code{waveband}: Wavelength spread in nm.
}}
\examples{
spread(sun.spct)

}

