% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.tag.r
\name{wb2rect_spct}
\alias{wb2rect_spct}
\title{Create tagged spectrum from wavebands}
\usage{
wb2rect_spct(w.band, short.names = TRUE)
}
\arguments{
\item{w.band}{waveband or list of waveband objects The waveband(s) determine
the wavelengths in variable \code{w.length} of the returned spectrum}

\item{short.names}{logical Flag indicating whether to use short or long names
for wavebands}
}
\value{
A \code{generic.spectrum} object, with columns w.length, wl.low,
  wl.hi, wl.color, wb.color and wb.name. The w.length values are the
  midpoint of the wavebands, wl.low and wl.high give the boundaries of the
  wavebands, wl.color the color definition corresponding to the wavelength at
  the center of the waveband and wb.color the color of the waveband as a
  whole (assuming a flat energy irradiance spectrum). Different spectral data
  variables are set to zero and added making the returned value compatible
  with classes derived from \code{generic_spct}.
}
\description{
Create a generic_spct object with wavelengths from the range of wavebands in
a list. The spectrum is suitable for plotting labels, symbols, rectangles or
similar, as the midpoint of each waveband is added to the spectrum.
}
\seealso{
Other tagging and related functions: \code{\link{is_tagged}},
  \code{\link{tag}}, \code{\link{untag}},
  \code{\link{wb2spct}}, \code{\link{wb2tagged_spct}}
}
