% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.absorbance.R
\name{absorbance}
\alias{absorbance}
\alias{absorbance.default}
\alias{absorbance.filter_spct}
\alias{absorbance.object_spct}
\alias{absorbance.filter_mspct}
\alias{absorbance.object_mspct}
\title{Absorbance}
\usage{
absorbance(spct, w.band, quantity, wb.trim, use.hinges, ...)

\method{absorbance}{default}(spct, w.band, quantity, wb.trim, use.hinges, ...)

\method{absorbance}{filter_spct}(spct, w.band = NULL, quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = getOption("photobiology.use.hinges", default = NULL), ...)

\method{absorbance}{object_spct}(spct, w.band = NULL, quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = getOption("photobiology.use.hinges", default = NULL), ...)

\method{absorbance}{filter_mspct}(spct, w.band = NULL, quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = getOption("photobiology.use.hinges", default = NULL), ...,
  attr2tb = NULL, idx = !is.null(names(spct)))

\method{absorbance}{object_mspct}(spct, w.band = NULL, quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = getOption("photobiology.use.hinges", default = NULL), ...,
  attr2tb = NULL, idx = !is.null(names(spct)))
}
\arguments{
\item{spct}{an R object}

\item{w.band}{waveband or list of waveband objects or a numeric vector of
length two. The waveband(s) determine the region(s) of the spectrum that
are summarized. If a numeric range is supplied a waveband object is
constructed on the fly from it.}

\item{quantity}{character string One of "average" or "mean", "total",
"contribution", "contribution.pc", "relative" or "relative.pc"}

\item{wb.trim}{logical Flag indicating if wavebands crossing spectral data
boundaries are trimmed or ignored}

\item{use.hinges}{logical Flag indicating whether to use hinges to reduce
interpolation errors}

\item{...}{other arguments (possibly ignored)}

\item{attr2tb}{character vector, see \code{\link{add_attr2tb}} for the syntax for \code{attr2tb} passed as is to formal parameter \code{col.names}.}

\item{idx}{logical whether to add a column with the names of the elements of
spct}
}
\value{
A named \code{numeric} vector in the case of methods for individual
  spectra, with one value for each \code{waveband} passed to parameter
  \code{w.band}. A \code{data.frame} in the case of collections of spectra,
  containing one column for each \code{waveband} object, an index column with
  the names of the spectra, and optionally additional columns with metadata
  values retrieved from the attributes of the member spectra.

  By default values are only integrated, but depending on the argument passed
  to parameter \code{quantity} they can be re-expressed as relative fractions
  or percentages. In the case of vector output, \code{names} attribute is set
  to the name of the corresponding waveband unless a named list is supplied
  in which case the names of the list members are used.
}
\description{
Function to calculate the mean, total, or other summary of absorbance for
spectral data stored in a \code{filter_spct} or in an \code{object_spct}.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{filter_spct}: Specialization for filter spectra

\item \code{object_spct}: Specialization for object spectra

\item \code{filter_mspct}: Calculates absorbance from a \code{filter_mspct}

\item \code{object_mspct}: Calculates absorbance from a \code{object_mspct}
}}

\note{
The \code{use.hinges} parameter controls speed optimization. The
  defaults should be suitable in most cases. Only the range of wavelengths in
  the wavebands is used and all BSWFs are ignored.
}
\examples{
absorbance(polyester.spct, new_waveband(400,700))
absorbance(yellow_gel.spct, new_waveband(400,700))
absorbance(yellow_gel.spct, split_bands(c(400,700), length.out = 3))
absorbance(yellow_gel.spct, split_bands(c(400,700), length.out = 3),
        quantity = "average")
absorbance(yellow_gel.spct, split_bands(c(400,700), length.out = 3),
        quantity = "total")
absorbance(yellow_gel.spct, split_bands(c(400,700), length.out = 3),
        quantity = "relative")
absorbance(yellow_gel.spct, split_bands(c(400,700), length.out = 3),
        quantity = "relative.pc")
absorbance(yellow_gel.spct, split_bands(c(400,700), length.out = 3),
        quantity = "contribution")
absorbance(yellow_gel.spct, split_bands(c(400,700), length.out = 3),
        quantity = "contribution.pc")

}
