% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zmspct.classes.R
\name{as.generic_mspct}
\alias{as.chroma_mspct}
\alias{as.cps_mspct}
\alias{as.filter_mspct}
\alias{as.generic_mspct}
\alias{as.object_mspct}
\alias{as.raw_mspct}
\alias{as.reflector_mspct}
\alias{as.response_mspct}
\alias{as.source_mspct}
\title{Collection-of-spectra copy-constructor}
\usage{
as.generic_mspct(x, force.spct.class = FALSE)

as.raw_mspct(x)

as.cps_mspct(x)

as.source_mspct(x, time.unit = c("second", "day", "exposure"),
  bswf.used = c("none", "unknown"),
  strict.range = getOption("photobiology.strict.range", default = FALSE))

as.response_mspct(x, time.unit = "second")

as.filter_mspct(x, Tfr.type = c("total", "internal"), strict.range = TRUE)

as.reflector_mspct(x, Rfr.type = c("total", "specular"),
  strict.range = TRUE)

as.object_mspct(x, Tfr.type = c("total", "internal"), Rfr.type = c("total",
  "specular"), strict.range = TRUE)

as.chroma_mspct(x)
}
\arguments{
\item{x}{a list of spectral objects or a list of objects such as data frames
that can be converted into spectral objects.}

\item{force.spct.class}{logical indicating whether to change the class
of members to \code{generic_spct} or retain the existing class.}

\item{time.unit}{character A string, "second", "day" or "exposure"}

\item{bswf.used}{character}

\item{strict.range}{logical Flag indicating whether off-range values result
in an error instead of a warning}

\item{Tfr.type}{a character string, either "total" or "internal"}

\item{Rfr.type}{a character string, either "total" or "specular"}
}
\value{
These functions return a copy of \code{x} converted into a given
  class of spectral collection object, if \code{x} is a valid argument to the
  corresponding set function.
}
\description{
Return a copy of an R object with its class set to a given type
  of spectrum.
}
\note{
Members of \code{generic_mspct} objects can be heterogeneous: they can
  belong any class derived from \code{generic_spct} and class is not
  enforced. In this case when \code{x} is a list of data frames,
  \code{force.spct.class = TRUE} needs to be supplied.
}
\seealso{
Other creation of spectral objects functions: \code{\link{as.generic_spct}},
  \code{\link{source_spct}}
}

