% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wl-conversions.R
\name{wl2wavenumber}
\alias{wl2wavenumber}
\alias{wavenumber2wl}
\alias{wl2frequency}
\alias{frequency2wl}
\alias{wl2energy}
\alias{energy2wl}
\title{Wavelength conversions}
\usage{
wl2wavenumber(w.length, unit.exponent = 0)

wavenumber2wl(wavenumber, unit.exponent = 0)

wl2frequency(w.length, unit.exponent = 0)

frequency2wl(frequency, unit.exponent = 0)

wl2energy(w.length, unit.exponent = 0, unit = "joule")

energy2wl(photon.energy, unit.exponent = 0, unit = "joule")
}
\arguments{
\item{w.length}{numeric wavelength (nm)}

\item{unit.exponent}{integer Exponent of the scale multiplier implicit in
result, e.g., use 3 for kJ.}

\item{wavenumber}{numeric Wave number in waves per metre, possibly
with a scale factor according to \code{unit.exponent}.}

\item{frequency}{numeric Frequency in Hz, possibly
with the scale factor according to \code{unit.exponent}.}

\item{unit}{character One of "joule" or "eV".}

\item{photon.energy}{numeric Energy of one photon in joule or eV, possibly
with a scale factor according to \code{unit.exponent}.}
}
\description{
Convert wavelength (nm) into wave number, frequency (Hz) or energy per photon
(J, or eV) and back.
}
\details{
These functions always expect as input and return wavelengths
  expressed in nanometres (nm) as all other functions in the R for
  photobiology suite of packages. Conversions depend on Plank's constant,
  \emph{h}, the speed of light in vacuum, \emph{c}, and Avogadro's number,
  \eqn{N_A}. The values used for these constants have at least nine
  significant digits.
}
\examples{

wl2wavenumber(600) # wavelength in nm -> wave number
wavenumber2wl(1666666.66) # wave number -> wavelength in nm
wl2frequency(600) # wavelength in nm -> wave frequency (Hz)
frequency2wl(499654096666667) # wave frequency (Hz) -> wavelength in nm
wl2energy(600) # wavelength in nm -> energy of one photon (J)
wl2energy(600, unit = "eV") # wavelength in nm -> energy of one photon (eV)
wl2energy(600,
          unit.exponent = -3,
          unit = "eV")  # wavelength in nm -> energy of one photon (meV)
energy2wl(2066.40330,
          unit.exponent = -3,
          unit = "eV")  # energy of one photon (meV) -> wavelength (nm)

}
