% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.mean.se.band.r
\name{s_mean_se_band}
\alias{s_mean_se_band}
\alias{s_mean_se_band.default}
\alias{s_mean_se_band.filter_mspct}
\alias{s_mean_se_band.source_mspct}
\alias{s_mean_se_band.response_mspct}
\alias{s_mean_se_band.reflector_mspct}
\alias{s_mean_se_band.calibration_mspct}
\alias{s_mean_se_band.cps_mspct}
\alias{s_mean_se_band.raw_mspct}
\title{Mean plus and minus standard error from collection of spectra}
\usage{
s_mean_se_band(x, na.rm, mult, ...)

\method{s_mean_se_band}{default}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se_band}{filter_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se_band}{source_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se_band}{response_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se_band}{reflector_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se_band}{calibration_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se_band}{cps_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se_band}{raw_mspct}(x, na.rm = FALSE, mult = 1, ...)
}
\arguments{
\item{x}{An R object Currently this package defines methods for collections of
spectral objects.}

\item{na.rm}{logical A value indicating whether NA values should be stripped
before the computation proceeds.}

\item{mult}{numeric number of multiples of standard error.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
If \code{x} is a collection spectral of objects, such as a
  "filter_mspct" object, the returned object is of same class as the
  members of the collection, such as "filter_spct", containing the mean
  spectrum.
}
\description{
A method to compute the mean of values and se across members of a collections
of spectra. Computes the mean at each wavelength across all the spectra in
the collection returning a spectral object.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: 

\item \code{filter_mspct}: 

\item \code{source_mspct}: 

\item \code{response_mspct}: 

\item \code{reflector_mspct}: 

\item \code{calibration_mspct}: 

\item \code{cps_mspct}: 

\item \code{raw_mspct}: 
}}

\note{
Trimming of extreme values and omission of NAs is done separately at
  each wavelength. Interpolation is not applied, so all spectra in \code{x}
  must share the same set of wavelengths.

  Objects of classes raw_spct and cps_spct can contain data from multiple
  scans. This functions are implemented for these classes only for the case
  when all member spectra contain data for a single scan, or spliced into a
  single column in the case of cps_spct members.
}
\seealso{
See \code{\link[base]{mean}} for the \code{mean()} method used for
  the computations.
}
