% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_spectrogram.R
\name{draw_spectrogram}
\alias{draw_spectrogram}
\title{Draw spectrograms}
\usage{
draw_spectrogram(
  sound,
  fs = 22050,
  text_size = 1,
  windowlength = 5,
  timestep = -1000,
  padding = 10,
  preemphasisf = 50,
  maxfreq = 5000,
  colors = FALSE,
  dynamicrange = 50,
  nlevels = dynamicrange,
  show = TRUE,
  window = "kaiser",
  windowparameter = 3,
  quality = FALSE,
  x_axis = TRUE,
  title = NULL
)
}
\arguments{
\item{sound}{Either a numeric vector representing a sequence of samples taken from a sound wave or a sound object created with the loadsound() or makesound() functions.}

\item{fs}{The sampling frequency in Hz. If a sound object is passed this does not need to be specified.}

\item{text_size}{numeric, text size (default = 1).}

\item{windowlength}{The desired analysis window length in milliseconds.}

\item{timestep}{If a negative value is given, -N, then N equally-spaced time steps are calculated. If a positive number is given, this is the spacing between adjacent analyses, in milliseconds.}

\item{padding}{The amount of zero padding for each window, measured in units of window length. For example, if the window is 50 points, and padding = 10, 500 zeros will be appended to each window.}

\item{preemphasisf}{Preemphasis of 6 dB per octave is added to frequencies above the specified frequency. For no preemphasis, set to a frequency higher than the sampling frequency.}

\item{maxfreq}{the maximum frequency to be displayed for the spectrogram up to a maximum of fs/2. This is set to 5000 Hz by default.}

\item{colors}{If TRUE, a color spectrogram will be displayed. If FALSE, greyscale is used. If a vector of colors is provided, these colors are used to create the spectrogram.}

\item{dynamicrange}{Values greater than this many dB below the maximum will be displayed in the same color.}

\item{nlevels}{The number of divisions to be used for the z-axis of the spectrogram. By default it is set equal to the dynamic range, meaning that a single color represents 1 dB on the z-axis.}

\item{show}{If FALSE, no spectrogram is plotted. This is useful if the user would like to perform an action on an existing spectrogram plot without having to redraw it.}

\item{window}{the window to be applied to the signal, applied by the windowfunc function in this package.}

\item{windowparameter}{the parameter for the window to be applied to the signal, if appropriate.}

\item{quality}{If TRUE, a contour plot is created, which results in a high-quality image that may be slow to plot. If FALSE, a lower-quality image is created that plots much faster.}

\item{x_axis}{If TRUE then draw x axis.}

\item{title}{Character with the title.}
}
\description{
This function was slightly changed from \code{phonTools::spectrogram()}. Argument description is copied from \code{phonTools::spectrogram()}.
}
\author{
Santiago Barreda <sbarreda@ucdavis.edu>
}
