% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoFitPhenology.R
\name{AutoFitPhenology}
\alias{AutoFitPhenology}
\title{Automatic fit for phenology and tests}
\usage{
AutoFitPhenology(data = stop("A dataset must be provided"),
  progressbar = TRUE, ...)
}
\arguments{
\item{data}{Dataset generated with add_phenology()}

\item{progressbar}{If FALSE, do not show the progress bar}

\item{...}{Parameters for fit_phenology()}
}
\value{
A list with 12 elements corresponding to the 12 tested models
}
\description{
This function is used to test several combinations of fit at a time.
}
\details{
AutoFitPhenology runs fit for phenology and tests several combinations
}
\examples{
\dontrun{
library(phenology)
# Read a file with data
Gratiot <- read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", header=FALSE)
data(Gratiot)
# Generate a formatted list nammed data_Gratiot 
data_Gratiot <- add_phenology(Gratiot, name="Complete", 
		reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Run the optimisation
result_Gratiot_Auto <- AutoFitPhenology(data=data_Gratiot)
result_Gratiot_Auto <- AutoFitPhenology(data=data_Gratiot, 
          control=list(trace=0, REPORT=100, maxit=500))
}
}
\author{
Marc Girondot
}
