% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weib_percentile_ci.R
\name{weib_percentile_ci}
\alias{weib_percentile_ci}
\title{Calculating the CIs of a percentile estimate of a seasonal abundance
distribution using the non-parametric bootstrapping.}
\usage{
weib_percentile_ci(
  observations,
  iterations,
  percentile,
  bootstraps,
  type = "perc",
  conf = 0.95,
  parallelize = "no",
  ncpus = getOption("boot.ncpus", 1L),
  cl = NULL
)
}
\arguments{
\item{observations}{is a vector of dates/time of observations given as
numeric values}

\item{iterations}{is the number of iterations you want to run to create
empirical bootstrapping to estimate bias of original CDF. The bias is used to
calculate a bias corrected estimate of the percentile bound.}

\item{percentile}{is the percentile of the cumulative distribution function
of interest}

\item{bootstraps}{is the number of bootstraps you want to run to create the
CIs}

\item{type}{A vector of character strings representing the type of intervals
required to calculate the CI. Defaults to "perc". See ??boot.ci for more
information.}

\item{conf}{The confidence level wanted. Defaults to 95\% CI.}

\item{parallelize}{The type of parallel operation to be used (if any). If
missing, the default is that no parallelization will occur. Parallelization
options are "multicore" and "snow"}

\item{ncpus}{An integer that represents the number of processes to be
used in parallel operation.}

\item{cl}{An optional parallel or snow cluster for use if parallel = "snow".
If not supplied, a cluster on the local machine is created for
the duration of the boot call.}
}
\value{
The Weibull-corrected estimate of the percentile of interest and CIs.
}
\description{
\code{weib_percentile_ci} uses non-parametric bootstrapping
from the boot package to estimate 95% CIs around a weib_percentile estimate
}
\examples{

# Gather sightings of iNaturalist observations for four species:
# Danaus plexippus, Speyeria cybele, Rudbeckia hirta, and Asclepias syriaca

# Estimate when the first 50 percent of individuals of the butterfly species
# Speyeria cybele are in flight. Note, only 10 iterations are beingg used
# in this example to keep computation time low, but more iterations should
# be used to get a more stable result. See vignette for parallelization
# options.

\donttest{
data(inat_examples)
s_cybele <- subset(inat_examples, scientific_name == "Speyeria cybele")
weib_percentile_ci(observations = s_cybele$doy, iterations = 10,
                   percentile = 0.5, bootstraps = 100)
}

}
\keyword{percentile}
\keyword{phenology}
\keyword{weibull}
