% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eff_summary.R
\name{eff_suggest}
\alias{eff_suggest}
\title{Suggest the input \code{eff.structure} of function \code{SimPRMD} with
selected \code{eff.sd_tran}}
\usage{
eff_suggest(eff.M, eff.sd, eff.sd_trans, n.sim = 30000)
}
\arguments{
\item{eff.M}{The efficacy mean matrix whose (i,j)th element save the
target mean of the efficacy data}

\item{eff.sd}{The target standard deviation matrix for all dose and
cycles. Notice that the generated efficacy may have different standard
deviation matrix due to the correlations across cycles}

\item{eff.sd_trans}{The eff.sd_trans for test. Notice variance of the
generated efficacy data will be effected by \code{eff.sd_trans}.}

\item{n.sim}{The number of simulations for the numerical calculation in
the function. The default is 30,000}
}
\value{
\item{eff.suggest}{The matrix suggested for the input
  \code{eff.structure} of function \code{SimPRMD}}
}
\description{
Suggest the input \code{eff.structure} of function SimPRMD  with selected
\code{eff.sd_tran} for given efficacy mean matrix and efficacy standard
deviation
}
\examples{
# Provide an target efficacy mean matrix for all dose and cycles
eff.M <- matrix(rep(3:8/10, 6), nrow = 6, ncol = 6)

# Give a target standard deviation matrix for all dose and cycles
# Notice that the generated efficacy may have difference standard deviation
# matrix due to the correlations across cycles
eff.sd <- matrix(0.2, nrow = 6, ncol = 6)

# Select a eff.sd_trans for testing. The efficacy variance are mainly
# controlled by the eff.sd_trans
eff.sd_trans <- 1.5  # or other positive value
eff.structure <- eff_suggest(eff.M = eff.M, eff.sd = eff.sd,
                             eff.sd_trans = eff.sd_trans)

# check whether the suggested eff.M and the selected sd_trans
# generate the desirable scenario
eff.Sigma <- diag(6)
diag(eff.Sigma[-1,]) = 0.5
diag(eff.Sigma[, -1]) = 0.5
eff.check <- eff_summary(eff.structure = eff.structure,
                         eff.Sigma = eff.Sigma,
                         eff.sd_trans = eff.sd_trans,
                         plot.flag = FALSE)
eff.check$eff.M
eff.check$eff.cor.ls


}
