% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{add_iov}
\alias{add_iov}
\title{add_iov}
\usage{
add_iov(model, occ, list_of_parameters = NULL, eta_names = NULL)
}
\arguments{
\item{model}{(Model) Pharmpy model to add new IOVs to.}

\item{occ}{(str) Name of occasion column.}

\item{list_of_parameters}{(str, vector) List of names of parameters and random variables. Accepts random variable names, parameter
names, or a mix of both.}

\item{eta_names}{(str, vector) Custom names of new etas. Must be equal to the number of input etas times the number of
categories for occasion.}
}
\value{
(Model) Reference to the same model
}
\description{
Adds IOVs to :class:\code{pharmpy.model}.

Initial estimate of new IOVs are 10\% of the IIV eta it is based on.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
add_iov(model, "TIME", "CL")
model$statements$find_assignment("CL")
}
}
\seealso{
add_iiv

remove_iiv

remove_iov
}
