% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmf.R
\name{pmf}
\alias{pmf}
\title{Probability mass functions of a randomised clinical trial design that assumes
a Bernoulli distributed primary outcome variable}
\usage{
pmf(
  des = ph2rand::des_one_stage(),
  pi = des$opchar[, 1:2],
  k = 1:des$J,
  summary = FALSE
)
}
\arguments{
\item{des}{An object of class \code{ph2rand_des}, as returned by
\code{\link{des_one_stage}} or \code{\link{des_two_stage}}. Defaults to
\code{ph2rand::des_one_stage()}.}

\item{pi}{A \code{\link{numeric}} \code{\link{vector}} with two elements, or
a \code{\link{numeric}} \code{\link{matrix}} or \code{\link{data.frame}} with
two columns, giving the response rate scenarios to consider. The first
element/column should correspond to the control arm and the second
element/column to the experimental arm. Defaults to \code{des$opchar[, 1:2]}.}

\item{k}{A \code{\link{numeric}} \code{\link{vector}} indicating which stages
to consider in determining the probability mass functions. That is, it will
condition the calculations on the trial ending in the stages given in
\code{k}. Defaults to \code{1:des$J} (i.e., to all stages of the given
design).}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}
}
\value{
A \code{\link{list}} with additional class \code{"ph2rand_pmf"},
containing each of the input parameters along with a tibble in the slot
\code{$pmf}, which gives the determined probability mass functions.
}
\description{
\code{pmf} determines probability mass functions of a design returned by
\code{\link{des_one_stage}} or \code{\link{des_two_stage}}, under given
response rate scenarios (see \code{pi}).
}
\examples{
# The default two-stage design
des <- des_two_stage()
# Its probability mass function under the uninteresting and interesting
# scenarios
pmf <- pmf(des)
# The same probability mass functions, conditioning on the trial ending in
# stage 2
pmf <- pmf(des, k = 2)
}
\seealso{
\code{\link{des_one_stage}}, \code{\link{des_two_stage}},
\code{\link{plot.ph2rand_terminal}}.
}
