/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps;

import java.util.List;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectFile;

public class ExecStack {
    private PSObjectArray stack = new PSObjectArray();

    public PSObjectFile getTopmostFile() throws PSError {
        for (int i = this.size() - 1; i >= 0; --i) {
            PSObject pSObject = this.stack.get(i);
            if (!(pSObject instanceof PSObjectFile)) continue;
            return pSObject.toFile();
        }
        return null;
    }

    public PSObject getNextToken() throws PSError, ProgramError {
        if (this.stack.size() == 0) {
            return null;
        }
        PSObject pSObject = this.getTop();
        if (pSObject != null) {
            List<PSObject> list = pSObject.token();
            if (list.size() == 2) {
                return list.get(0);
            }
            if (list.size() == 3) {
                this.pop();
                PSObject pSObject2 = list.get(0);
                if (pSObject2 != null) {
                    this.push(pSObject2);
                }
                return list.get(1);
            }
            this.pop();
            return null;
        }
        return null;
    }

    public PSObject pop() {
        try {
            int n = this.stack.size();
            return this.stack.remove(n - 1);
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            return null;
        }
    }

    public void push(PSObject pSObject) {
        this.stack.addToEnd(pSObject);
    }

    public int size() {
        return this.stack.size();
    }

    public PSObject getTop() {
        int n = this.stack.size();
        try {
            return this.stack.get(n - 1);
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            return null;
        }
    }

    public PSObjectArray getStack() {
        return this.stack;
    }
}

