/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.colors;

import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.resources.colors.PSColor;

public class DeviceRGB
extends PSColor {
    public static final PSObjectName FAMILYNAME = new PSObjectName("/DeviceRGB");
    private static final double[] DEFAULT_LEVELS = new double[]{0.0, 0.0, 0.0};

    public DeviceRGB() {
        try {
            this.setColor(DEFAULT_LEVELS);
        }
        catch (PSError pSError) {
        }
        catch (ProgramError programError) {
            // empty catch block
        }
    }

    public DeviceRGB clone() throws CloneNotSupportedException {
        DeviceRGB deviceRGB = (DeviceRGB)super.clone();
        return deviceRGB;
    }

    public double[] getCMYK() {
        return DeviceRGB.convertRGBtoCMYK(this.getLevel(0), this.getLevel(1), this.getLevel(2));
    }

    public PSObjectArray getColorSpace() {
        PSObjectArray pSObjectArray = new PSObjectArray();
        pSObjectArray.addToEnd(new PSObjectName("DeviceRGB", true));
        return pSObjectArray;
    }

    public PSObjectName getFamilyName() {
        return FAMILYNAME;
    }

    public double getGray() {
        return 0.3 * this.getLevel(0) + 0.59 * this.getLevel(1) + 0.11 * this.getLevel(2);
    }

    public double[] getHSB() {
        return DeviceRGB.convertRGBtoHSB(this.getLevel(0), this.getLevel(1), this.getLevel(2));
    }

    public int getNrComponents() {
        return 3;
    }

    public int getNrInputValues() {
        return this.getNrComponents();
    }

    public String getPreferredColorSpace() {
        return "RGB";
    }

    public double[] getRGB() {
        double[] dArray = new double[]{this.getLevel(0), this.getLevel(1), this.getLevel(2)};
        return dArray;
    }

    public static double[] convertHSBtoRGB(double d, double d2, double d3) {
        double d4 = d % 1.0;
        double d5 = Math.floor(d4 * 6.0);
        double d6 = d4 * 6.0 - d5;
        double d7 = d3 * (1.0 - d2);
        double d8 = d3 * (1.0 - d6 * d2);
        double d9 = d3 * (1.0 - (1.0 - d6) * d2);
        double[] dArray = new double[3];
        switch ((int)d5) {
            case 0: {
                dArray[0] = d3;
                dArray[1] = d9;
                dArray[2] = d7;
                break;
            }
            case 1: {
                dArray[0] = d8;
                dArray[1] = d3;
                dArray[2] = d7;
                break;
            }
            case 2: {
                dArray[0] = d7;
                dArray[1] = d3;
                dArray[2] = d9;
                break;
            }
            case 3: {
                dArray[0] = d7;
                dArray[1] = d8;
                dArray[2] = d3;
                break;
            }
            case 4: {
                dArray[0] = d9;
                dArray[1] = d7;
                dArray[2] = d3;
                break;
            }
            default: {
                dArray[0] = d3;
                dArray[1] = d7;
                dArray[2] = d8;
            }
        }
        return dArray;
    }

    public static double[] convertRGBtoHSB(double d, double d2, double d3) {
        double d4;
        double d5 = Math.max(d, Math.max(d2, d3));
        double d6 = d5 == (d4 = Math.min(d, Math.min(d2, d3))) ? 0.0 : (d5 == d && d2 >= d3 ? 0.16666666666666666 * (d2 - d3) / (d5 - d4) : (d5 == d && d2 < d3 ? 0.16666666666666666 * (d2 - d3) / (d5 - d4) + 1.0 : (d5 == d2 ? 0.16666666666666666 * (d3 - d) / (d5 - d4) + 0.3333333333333333 : 0.16666666666666666 * (d - d2) / (d5 - d4) + 0.6666666666666666)));
        double d7 = d5 == 0.0 ? 0.0 : 1.0 - d4 / d5;
        double d8 = d5;
        double[] dArray = new double[]{d6, d7, d8};
        return dArray;
    }

    public static double[] convertRGBtoCMYK(double d, double d2, double d3) {
        double d4 = 1.0 - d;
        double d5 = 1.0 - d2;
        double d6 = 1.0 - d3;
        double d7 = Math.min(d4, Math.min(d5, d6));
        if (Math.abs(d7 - 1.0) < 1.0E-10) {
            d4 = 0.0;
            d5 = 0.0;
            d6 = 0.0;
        } else {
            d4 = (d4 - d7) / (1.0 - d7);
            d5 = (d5 - d7) / (1.0 - d7);
            d6 = (d6 - d7) / (1.0 - d7);
        }
        double[] dArray = new double[]{d4, d5, d6, d7};
        return dArray;
    }
}

