/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf;

import com.martiansoftware.jsap.JSAPResult;
import java.io.IOException;
import java.text.ParseException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eps2pgf.Converter;
import net.sf.eps2pgf.Options;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.QuitOpExecuted;
import net.sf.eps2pgf.util.Eps2pgfFormatter;
import net.sf.eps2pgf.util.Eps2pgfHandler;

public final class Main {
    public static final String APP_NAME = "Eps2pgf";
    public static final String APP_VERSION = "0.7.0";
    public static final String APP_BUILD_DATE = "2008-08-24";
    private static Options opts = new Options();
    private static final Logger LOG = Logger.getLogger("net.sourceforge.eps2pgf");

    private Main() {
    }

    public static void main(String[] stringArray) {
        Object object;
        Logger logger = LOG.getParent();
        Handler[] handlerArray = logger.getHandlers();
        logger.removeHandler(handlerArray[0]);
        Eps2pgfHandler eps2pgfHandler = new Eps2pgfHandler();
        eps2pgfHandler.setFormatter(new Eps2pgfFormatter());
        LOG.addHandler(eps2pgfHandler);
        JSAPResult jSAPResult = opts.parse(stringArray);
        if (opts.isHelpFlagSet()) {
            Main.printVersionCopyright();
            Main.printHelp();
            System.exit(0);
        }
        if (opts.isVersionFlagSet()) {
            Main.printVersionCopyright();
            System.exit(0);
        }
        if (!jSAPResult.success()) {
            System.err.println();
            object = jSAPResult.getErrorMessageIterator();
            while (object.hasNext()) {
                System.err.println("Error: " + object.next());
            }
            System.exit(1);
        }
        if ((object = System.getenv("EPS2PGF_DEBUG")) != null) {
            if (((String)object).equals("fine")) {
                LOG.setLevel(Level.FINE);
            } else if (((String)object).equals("finer")) {
                LOG.setLevel(Level.FINER);
            } else {
                LOG.setLevel(Level.ALL);
            }
        } else if (opts.isVerboseFlagSet()) {
            LOG.setLevel(Level.INFO);
        } else {
            LOG.setLevel(Level.WARNING);
        }
        Converter converter = new Converter(opts);
        try {
            converter.convert();
        }
        catch (IOException iOException) {
            LOG.severe("Execution failed due to an error while reading from or writing to a file.");
        }
        catch (ParseException parseException) {
            LOG.severe("Execution failed due to an error while parsing the text replacements file.");
        }
        catch (QuitOpExecuted quitOpExecuted) {
        }
        catch (PSError pSError) {
            LOG.severe("Execution failed due to a PostScript error in the input file.");
        }
        catch (ProgramError programError) {
            LOG.severe("Execution failed due to an error in the program. Please report this to the author.");
        }
    }

    public static String getNameVersion() {
        return "Eps2pgf 0.7.0 (build on 2008-08-24)";
    }

    public static void printVersionCopyright() {
        System.out.println(Main.getNameVersion());
        System.out.println("");
        System.out.println("Copyright 2007, 2008 Paul Wagenaars <paul@wagenaars.org>");
        System.out.println("");
        System.out.println("Licensed under the Apache License, Version 2.0 (the \"License\");");
        System.out.println("you may not use this file except in compliance with the License.");
        System.out.println("You may obtain a copy of the License at");
        System.out.println("");
        System.out.println("    http://www.apache.org/licenses/LICENSE-2.0");
        System.out.println("");
        System.out.println("Unless required by applicable law or agreed to in writing, software");
        System.out.println("distributed under the License is distributed on an \"AS IS\" BASIS,");
        System.out.println("WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
        System.out.println("See the License for the specific language governing permissions and");
        System.out.println("limitations under the License.");
        System.out.println("");
        System.out.println("See NOTICE.txt for more information and LICENSE.txt for the complete license.");
    }

    public static void printHelp() {
        System.out.println();
        System.out.println("Usage: " + APP_NAME.toLowerCase() + " " + opts.getUsage());
        System.out.println();
        System.out.println(opts.getHelp());
    }
}

