% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pew_download.R
\name{pew_download}
\alias{pew_download}
\title{Download datasets from the Pew Research Center}
\usage{
pew_download(area = "politics", file_id,
  email = getOption("pew_email"), password = getOption("pew_password"),
  reset = FALSE, download_dir = "pew_data", msg = TRUE,
  convert = TRUE, delay = 2)
}
\arguments{
\item{area}{One of the seven research areas of the Pew Research Center 
(see details).}

\item{file_id}{The unique identifier (or optionally a vector of these identifiers)
for the dataset(s) to be downloaded (see details).}

\item{email, password}{Account information to submit to Pew Research Center (see details).}

\item{reset}{If TRUE, the register information will be reset. The default is FALSE.}

\item{download_dir}{The directory (relative to your working directory) to
which files from the Pew Research Center will be downloaded.}

\item{msg}{If TRUE, outputs a message showing which data set is being downloaded.}

\item{convert}{If TRUE, converts downloaded file(s) to .RData format.}

\item{delay}{If the speed of your connection to the Pew Data Center is particularly slow, 
\code{pew_download} may encounter problems.  Increasing the \code{delay} parameter
may help.}
}
\value{
The function downloads files.
}
\description{
\code{pew_download} provides a programmatic and reproducible means to download survey datasets from the Pew Research Center
}
\details{
The Pew Research Center has seven areas of research focus.  Pass one of the 
 following strings to the \code{area} argument to specify which area generated
 the datasets you want to download:
 
 \code{politics} U.S. Politics & Policy (the default)
 
 \code{journalism} Journalism & Media
 
 \code{socialtrends} Social & Demographic Trends
 
 \code{religion} Religion & Public Life
 
 \code{internet} Internet & Technology
 
 \code{science} Science & Society
    
 \code{hispanic} Hispanic Trends
 
 \code{global} Global Attitudes & Trends
 

 To avoid requiring others to edit your scripts to insert their own contact 
 information, the default is set to fetch this information from the user's 
 .Rprofile.  Before running \code{pew_download}, then, you should be sure to
 add these options to your .Rprofile substituting your info for the example below:

 \code{
  options("pew_email" = "jherrera@uppermidwest.edu"
         "pew_password" = "password123!")
 }
}
\examples{
\dontrun{
 pew_download(file_id = c("september-2018-political-survey", "june-2018-political-survey"))
}

}
