% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discriminationToFactorLoading.R
\name{discriminationToFactorLoading}
\alias{discriminationToFactorLoading}
\title{Discrimination (IRT) to Standardized Factor Loading.}
\usage{
discriminationToFactorLoading(a, model = "probit")
}
\arguments{
\item{a}{Discrimination parameter in item response theory.}

\item{model}{Model type. One of:
\itemize{
  \item \code{"logit"}
  \item \code{"probit"}
}}
}
\value{
Standardized factor loading.
}
\description{
Convert a discrimination parameter in item response theory to a
standardized factor loading.
}
\details{
Convert a discrimination parameter in item response theory to a
standardized factor loading
}
\examples{
discriminationToFactorLoading(0.5)
discriminationToFactorLoading(1.3)
discriminationToFactorLoading(1.3, model = "logit")

}
\seealso{
\url{https://aidenloe.github.io/introToIRT.html}
\url{https://stats.stackexchange.com/questions/228629/conversion-of-irt-logit-discrimination-parameter-to-factor-loading-metric}

Other IRT: 
\code{\link{fourPL}()},
\code{\link{itemInformation}()},
\code{\link{reliabilityIRT}()},
\code{\link{standardErrorIRT}()}
}
\concept{IRT}
