% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Iterator.R
\name{Iterator}
\alias{Iterator}
\title{Making an Irregular Sequence Iterator}
\usage{
Iterator(result, initial, yield)
}
\arguments{
\item{result}{R expression to run each time 'yield_next' is called}

\item{initial}{declare and initialize every variable that appears in 'result'}

\item{yield}{variable to yield when 'yield_next' is called}
}
\value{
An object of S3 type Iterator
}
\description{
Create an Iterator object, where the user defines a sequence and a
set of initial values, and then calls 'yield_next' to generate the
next element of the sequence.
}
\examples{
#Create the Collatz sequence starting with 50 and print out the first 30 elements
expr <- "if (n \%\% 2 == 0) n <- n / 2 else n <- n*3 + 1"
collatz <- Iterator(result = expr,
                    initial = c(n = 50),
                    yield = n)

seq <- yield_more(collatz, 30)

}
