% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_fuzzy_match.R
\name{get_ambiguous_matches}
\alias{get_ambiguous_matches}
\title{Retrieve Ambiguous Match Information for Peru Mammals}
\usage{
get_ambiguous_matches(
  match_result,
  type = c("genus", "species", "all"),
  save_to_file = FALSE,
  output_dir = tempdir()
)
}
\arguments{
\item{match_result}{A tibble returned by matching functions.}

\item{type}{Character. Type of ambiguous matches to retrieve:
\itemize{
\item \code{"genus"} (default): Ambiguous genus-level matches
\item \code{"species"}: Ambiguous species-level matches
\item \code{"all"}: Both types
}}

\item{save_to_file}{Logical. If TRUE, saves results to CSV.
Default is FALSE (CRAN compliant).}

\item{output_dir}{Character. Directory to save file if save_to_file = TRUE.
Defaults to \code{tempdir()}.}
}
\value{
A tibble with ambiguous match details, or NULL if none exist.
Includes original names, matched names, distances, and database metadata.
}
\description{
Extracts information about ambiguous matches (multiple candidates with
tied distances) from matching results. Useful for quality control and
manual curation. Adapted for peru_mammals (genus and species only).
}
\details{
During fuzzy matching, multiple candidates may have identical string
distances. The matching algorithm automatically selects the first candidate,
but this function allows you to review all alternatives for quality control.
}
