% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fourvalplot.R
\name{fourvalplot}
\alias{fourvalplot}
\title{Plot spider chart for four higher-order personal values}
\usage{
fourvalplot(
   df,
   valueMap,
   instrument,
   corrected = TRUE,
   standdev = TRUE,
   na.rm = TRUE
)
}
\arguments{
\item{df}{A dataframe containing computed values for the four higher-order personal values.}

\item{valueMap}{A named vector where names are the four higher-order personal values:
Openness to Change ("OPEN"), Self-enhancement ("SELFENH"), Conservation ("CONS"),
Self-transcendence ("SELFTRANS"). Vector values correspond to the column names in the dataframe.}

\item{instrument}{Character string specifying the type of instrument used.
Supported instruments: "svs", "pvq40", "pvq21", "twivi", "tivi".}

\item{corrected}{Logical. Indicates if data are ipsatized; if FALSE, data are given as raw scores (variable ranges depending on the type of instrument used). Default is TRUE.}

\item{standdev}{Logical. When TRUE, plots mean ± SD lines; when FALSE, plots only the mean. Default is TRUE.}

\item{na.rm}{Logical. When TRUE, NAs are ignored; when FALSE, NAs are preserved and will affect calculations. Default is TRUE.}
}
\value{
A spider chart visualizing the four higher-order values scores.
}
\description{
This function generates a spider chart based on four higher-order Basic Human Values:
Openness to Change, Self-Enhancement, Conservation, and Self-Transcendence.
This visualization helps in understanding the profile of higher-order values for individuals or groups.
}
\examples{
df <- data.frame(
  open_comp = sample(-4.5:+4.5, 3, replace = TRUE),
  selfenh_comp = sample(-4.5:+4.5, 3, replace = TRUE),
  cons_comp = sample(-4.5:+4.5, 3, replace = TRUE),
  selftrans_comp = sample(-4.5:+4.5, 3, replace = TRUE))
valueMap <- c(OPEN = "open_comp", SELFENH = "selfenh_comp",
              CONS = "cons_comp", SELFTRANS = "selftrans_comp")
persval::fourvalplot(df = df, valueMap = valueMap, instrument = "pvq40")
}
