# This file is sage code (GAP code, I guess) to generate zzz_dodecahedron.R.

# The group of permutations of the dodecahedron is represented in
# objects 'dod_face' and 'dod_edge' which show the dodecahedron group
# in terms of its faces and its edges respectively.  The dodecahedron
# group is isomorphic to A_5 (the alternating group on 5 elements) and
# thus has size 60.  The difficult bit is to identify the elements of
# the ground set with actual identifiable edges on megaminx_net.pdf
# model.

# To create the file zzz_dodecahedron.R, fire up SAGE and execute this
# file (cut-and-paste is fine).  Then the last two lines,
# dod_edge.list() and dod_face.list(), generate output that may be
# tidied to produce zzz_dodecahedron.R

# The dodecahedron group is isomorphic to A_5.  For the *full*
# dodecahedron group, which includes reflections, see file
# "full_dodecahedron_group.py".  Note that the full dodecahedron group
# is *not* isomorphic to S_5.

# It is possible to generate the dodecahedron group from two elements,
# and I am going to do this two ways: one for faces (SAGE object
# 'dod_face') and one for edges (SAGE object 'dod_edge').

# Cayley's theorem says that dod_edge is a subgroup of S_30 (as there
# are 30 edges) and dod_face is a subgroup of S_12 (as there are 12
# faces).

# The faces are numbered by the large-font number in the middle of each
# pentagon; the edges are numbered by the *smaller* of the two numbers
# on the edge piece.


# dod_face and dod_edge each are generated by two permutations.
# dod_face is generated by face1 and face2, and dod_edge is generated
# by edge1 and edge2.  face1 and face2 are permutations of the faces
# of a dodecahedron and edge1 and edge2 are permutations of the edges
# of a dodecahedron.

# To do face1 or edge1, put the model (that is, the model created by
# printing out megaminx_net.pdf) down on the desk with face 1
# uppermost.  Look at a position then rotate the model 72 degrees
# anticlockwise (sic) and note which face appears there.

# To do face2 or edge2, put your finger on vertex common to
# face1,face2,face3 [==v1/2/3] and balance it on the desk with
# v10/11/12 on the desk.  The model can swivel.  Rotate it 120 degrees
# anticlockwise about the axis joining v1/2/3 with v10/11/12.

# First, create 'dod_face'.  Create face1 and face2:

# face1 is the operation of rotating 72 degrees about axis passing
# through centers of faces 1,12:
face1 = PermutationGroupElement([(2,3,4,5,6),(7,11,10,9,8)]) 

# face2 is the operation of rotating 120 degrees about the axis
# passing through the vertex common to faces 1,2,3 and the vertex
# common to faces 10,11,12:

face2 = PermutationGroupElement([(3,1,2),(6,8,4),(9,7,5),(10,12,11)])


# Then dod_face is the group generated by face1 and face2:
dod_face  = PermutationGroup([face1,face2])

# Now verify that dod_face is indeed isomorphic to A_5:

dod_face.is_isomorphic(AlternatingGroup(5))   #should  be 'True'.



# Now create dod_edge, the group generated by edge1 and edge2.  NB: an
# edge is described as the smaller of the two facet numbers on that
# edge.

# edge1 is analogous to face1 and describes the same operation on the
# dodecahedron, but edge1 describes its effect on the edges of the
# dodecahedron instead of the faces:
edge1 = PermutationGroupElement([
    (10, 12, 14, 16, 18),
    (20, 32, 44, 56, 24),
    (26, 38, 40, 52, 64),
    (28, 30, 42, 54, 66),
    (72, 76,108, 96, 84),
    (74,112,100, 98, 86)])  


# edge2 is analogous to face2:
edge2 = PermutationGroupElement([
    (16,20,18),
    (10,24,38),
    (14,28,32),
    (12,26,30),
    (40,56,84),
    (44,66,72),
    (42,64,86),
    (52,96,74),
    (54,98,76),
    (100,112,108)])  
        

dod_edge  = PermutationGroup([edge1,edge2])

dod_edge.is_isomorphic(AlternatingGroup(5))  # should be TRUE

dod_edge.is_isomorphic(dod_face)  # should be TRUE as well!


actual_edges = (10, 12, 14, 16, 18, 20, 24, 26, 28, 30, 32, 38, 40, 42, 44, 52, 54, 56, 64, 66, 72, 74, 76, 84, 86, 96, 98, 100, 108, 112)


# following two lines take dod_face and dod_edge and print the group elements to the screen:
dod_face.list()
dod_edge.list()
