% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{calcSarf}
\alias{calcSarf}
\title{Calculates the SARF value of given input.}
\usage{
calcSarf(rf, ord = 1:(ncol(rf)), n = 1)
}
\arguments{
\item{rf}{Matrix of pairwise recombination frequencies.}

\item{ord}{Vector with marker order.}

\item{n}{Number of neighbors, which are included in the calculation.}
}
\value{
Single numeric value, which is the result of the SARF calculation.
}
\description{
The sum of adjecent recombination frequency (SARF) is a measure of how well the marker order is.
This function calculates it for a given matrix of pairwise recombination frequencies and marker order.
The SARF criterion can be extended to a neighborhood > 1.
}
\examples{
data(simTetra)
simTetrageno <- bases2genotypes(simTetra, 4)
rfMat <- calcRec(simTetrageno, 4)
split <- splitChr(rfMat, nchr = 7)
split <- sortLeafs(rfMat, split)
calcSarf(rfMat, split$order, n = 1)
calcSarf(rfMat, split$order, n = 2)
calcSarf(rfMat, split$order, n = 3)
}
\references{
Liu, B.H. 1998, \emph{Statistical genomics: linkage, mapping, and QTL analysis.}
}

