% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/functions-code.R
\name{perccal_interval}
\alias{perccal_interval}
\title{Calculates Percentile-Calibrated Linear Regression Confidence Intervals}
\usage{
perccal_interval(Xy, alpha, G = 20, B = 999, B2 = 999)
}
\arguments{
\item{Xy}{[n by (p+1)] matrix: X in columns 1 to p, y in column p+1.
X is the design matrix, and is assumed to not include a vector of one's.}

\item{alpha}{Target coverage desired.}

\item{G}{Number of grid points to evaluate calibrated percentile method
on each side over.}

\item{B}{Number of 1st stage bootstrap samples.}

\item{B2}{Number of 2nd stage double bootstrap samples.}
}
\value{
Return a (p+1)x2 matrix containing confidence intervals for all
regression coefficients, estimated via the perc-cal method.
}
\description{
This is the main function of the package.  It takes as inputs the
predictor/response matrix appended together, which can be either
a data frame or a matrix, along with the desired coverage and other
settings, and outputs marginal confidence intervals for each of the
predictors, including the intercept.
}
\examples{
set.seed(1234)
n = 32
B = 500
B2 = 500
G=20
x1=rnorm(n)
x2=rnorm(n)
eps=rnorm(n)
y = x1 + 2*x2 + eps
Xy = cbind(x1,x2,y)
alpha = .025
perccal_interval(Xy, alpha, G, B, B2)
}

