% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print-methods.R
\name{summary.pense_cvfit}
\alias{summary.pense_cvfit}
\alias{print.pense_cvfit}
\title{Summarize Cross-Validated PENSE Fit}
\usage{
\method{summary}{pense_cvfit}(object, alpha, lambda = "min", se_mult = 1, ...)

\method{print}{pense_cvfit}(x, alpha, lambda = "min", se_mult = 1, ...)
}
\arguments{
\item{object, x}{an (adaptive) PENSE fit with cross-validation information.}

\item{alpha}{Either a single number or missing.
If given, only fits with the given \code{alpha} value are considered.
If \code{lambda} is a numeric value and \code{object} was fit with multiple \code{alpha}
values, the parameter \code{alpha} must not be missing.}

\item{lambda}{either a string specifying which penalty level to use
(\code{"min"}, \code{"se"}, \verb{"\{x\}-se}")
or a single numeric value of the penalty parameter. See details.}

\item{se_mult}{If \code{lambda = "se"}, the multiple of standard errors to tolerate.}

\item{...}{ignored.}
}
\description{
If \code{lambda = "se"} and \code{object} contains fitted estimates for every penalization level in the sequence, extract the
coefficients of the most parsimonious model with prediction performance statistically indistinguishable from the best
model. This is determined to be the model with prediction performance within \code{se_mult * cv_se} from the best model.
}
\seealso{
\code{\link[=prediction_performance]{prediction_performance()}} for information about the estimated prediction performance.

\code{\link[=coef.pense_cvfit]{coef.pense_cvfit()}} for extracting only the estimated coefficients.

Other functions for plotting and printing: 
\code{\link{plot.pense_cvfit}()},
\code{\link{plot.pense_fit}()},
\code{\link{prediction_performance}()}
}
\concept{functions for plotting and printing}
