% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print-methods.R
\name{prediction_performance}
\alias{prediction_performance}
\alias{print.pense_pred_perf}
\title{Prediction Performance of Adaptive PENSE Fits}
\usage{
prediction_performance(..., alpha = NULL, lambda = "min", se_mult = 1)

\method{print}{pense_pred_perf}(x, ...)
}
\arguments{
\item{...}{one or more (adaptive) PENSE fits with cross-validation information.}

\item{alpha}{Either a numeric vector or \code{NULL} (default).
If given, only fits with the given \code{alpha} value are considered.
If \code{lambda} is a numeric value and \code{object} was fit with multiple \code{alpha}
values, the parameter \code{alpha} must not be missing.}

\item{lambda}{either a string specifying which penalty level to use
(\code{"min"}, \code{"se"}, \verb{"\{x\}-se}")
or a single numeric value of the penalty parameter. See details.}

\item{se_mult}{If \code{lambda = "se"}, the multiple of standard errors to tolerate.}

\item{x}{an object with information on prediction performance created with \code{prediction_performance()}.}
}
\value{
a data frame with details about the prediction performance of the given PENSE fits. The data frame
has a custom print method summarizing the prediction performances.
}
\description{
Extract the prediction performance of one or more (adaptive) PENSE fits.
}
\details{
If \code{lambda = "se"} and the cross-validation was performed with multiple replications, use the penalty level whit
prediction performance within \code{se_mult} of the best prediction performance.
}
\seealso{
\code{\link[=summary.pense_cvfit]{summary.pense_cvfit()}} for a summary of the fitted model.

Other functions for plotting and printing: 
\code{\link{plot.pense_cvfit}()},
\code{\link{plot.pense_fit}()},
\code{\link{summary.pense_cvfit}()}
}
\concept{functions for plotting and printing}
