% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlfitppml_int.R
\name{mlfitppml_int}
\alias{mlfitppml_int}
\title{General Penalized PPML Estimation}
\usage{
mlfitppml_int(
  y,
  x,
  fes,
  lambdas,
  penalty = "lasso",
  tol = 1e-08,
  hdfetol = 1e-04,
  colcheck = TRUE,
  colcheck_x = colcheck,
  colcheck_x_fes = colcheck,
  post = TRUE,
  cluster = NULL,
  method = "bic",
  IDs = 1:n,
  verbose = FALSE,
  xval = FALSE,
  standardize = TRUE,
  vcv = TRUE,
  phipost = TRUE,
  penweights = NULL,
  K = 15,
  gamma_val = NULL,
  mu = NULL
)
}
\arguments{
\item{y}{Dependent variable (a vector)}

\item{x}{Regressor matrix.}

\item{fes}{List of fixed effects.}

\item{lambdas}{Vector of penalty parameters.}

\item{penalty}{A string indicating the penalty type. Currently supported: "lasso" and "ridge".}

\item{tol}{Tolerance parameter for convergence of the IRLS algorithm.}

\item{hdfetol}{Tolerance parameter for the within-transformation step,
passed on to \code{collapse::fhdwithin}.}

\item{colcheck}{Logical. If \code{TRUE}, performs both checks in \code{colcheck_x} and \code{colcheck_x_fes}.
If the user specifies \code{colcheck_x} and \code{colcheck_x_fes} individually, this option is overwritten.}

\item{colcheck_x}{Logical. If \code{TRUE}, this checks collinearity between the independent variables and drops the
collinear variables.}

\item{colcheck_x_fes}{Logical. If \code{TRUE}, this checks whether the independent variables are perfectly explained
by the fixed effects drops those that are perfectly explained.}

\item{post}{Logical. If \code{TRUE}, estimates a post-penalty regression with the selected variables.}

\item{cluster}{Optional: a vector classifying observations into clusters (to use when calculating SEs).}

\item{method}{The user can set this equal to "plugin" to perform the plugin algorithm with
coefficient-specific penalty weights (see details). Otherwise, a single global penalty is used.}

\item{IDs}{A vector of fold IDs for k-fold cross validation. If left unspecified, each observation
is assigned to a different fold (warning: this is likely to be very resource-intensive).}

\item{verbose}{Logical. If \code{TRUE}, it prints information to the screen while evaluating.}

\item{xval}{Logical. If \code{TRUE}, it carries out cross-validation.}

\item{standardize}{Logical. If \code{TRUE}, x variables are standardized before estimation.}

\item{vcv}{Logical. If \code{TRUE} (the default), the post-estimation model includes standard errors.}

\item{phipost}{Logical. If \code{TRUE}, the plugin coefficient-specific penalty weights are iteratively
calculated using estimates from a post-penalty regression when \code{method == "plugin"}. Otherwise,
these are calculated using estimates from a penalty regression.}

\item{penweights}{Optional: a vector of coefficient-specific penalties to use in plugin lasso when
\code{method == "plugin"}.}

\item{K}{Maximum number of iterations for the plugin algorithm to converge.}

\item{gamma_val}{Numerical value that determines the regularization threshold as defined in Belloni, Chernozhukov, Hansen, and Kozbur (2016). NULL default sets parameter to 0.1/log(n).}

\item{mu}{A vector of initial values for mu that can be passed to the command.}
}
\value{
A list with the following elements:
\itemize{
\item \code{beta}: if \code{post = FALSE}, a \code{length(lambdas)} x \code{ncol(x)} matrix with
coefficient (beta) estimates from the penalized regressions. If \code{post = TRUE}, this is
the matrix of coefficients from the post-penalty regressions.
\item \code{beta_pre}: if \code{post = TRUE}, a \code{length(lambdas)} x \code{ncol(x)} matrix with
coefficient (beta) estimates from the penalized regressions.
\item \code{bic}: Bayesian Information Criterion.
\item \code{lambdas}: vector of penalty parameters.
\item \code{ses}: standard errors of the coefficients of the post-penalty regression. Note that
these are only provided when \code{post = TRUE}.
\item \code{rmse}: if \code{xval = TRUE}, a matrix with the root mean squared error (RMSE - column 2)
for each value of lambda (column 1), obtained by cross-validation.
\item \code{phi}: coefficient-specific penalty weights (only if \code{method == "plugin"}).
}
}
\description{
\code{mlfitppml_int} is the internal wrapper called by \code{mlfitppml} for penalized PPML estimation.
This in turn calls \code{penhdfeppml_int}, \code{penhdfeppml_cluster_int} and \code{hdfeppml_int}
as needed. It takes a vector with the dependent variable, a regressor matrix and a set of fixed
effects (in list form: each element in the list should be a separate HDFE). This is a flexible tool
that allows users to select:
\itemize{
\item Penalty type: either lasso or ridge.
\item Penalty parameter: users can provide a single global value for lambda (a single regression
is estimated), a vector of lambda values (the function estimates the regression using each of them,
sequentially) or even coefficient-specific penalty weights.
\item Method: plugin lasso estimates can be obtained directly from this function too.
\item Cross-validation: if this option is enabled, the function uses IDs provided by the user
to perform k-fold cross-validation and reports the resulting RMSE for all lambda values.
}
}
\details{
For technical details on the algorithms used, see \link{hdfeppml_int} (post-lasso regression),
\link{penhdfeppml_int} (standard penalized regression), \link{penhdfeppml_cluster_int} (plugin lasso),
and \link{xvalidate} (cross-validation).
}
\section{References}{

Breinlich, H., Corradi, V., Rocha, N., Ruta, M., Santos Silva, J.M.C. and T. Zylkin (2021).
"Machine Learning in International Trade Research: Evaluating the Impact of Trade Agreements",
Policy Research Working Paper; No. 9629. World Bank, Washington, DC.

Correia, S., P. Guimaraes and T. Zylkin (2020). "Fast Poisson estimation with high dimensional
fixed effects", \emph{STATA Journal}, 20, 90-115.

Gaure, S (2013). "OLS with multiple high dimensional category variables",
\emph{Computational Statistics & Data Analysis}, 66, 8-18.

Friedman, J., T. Hastie, and R. Tibshirani (2010). "Regularization paths for generalized linear
models via coordinate descent", \emph{Journal of Statistical Software}, 33, 1-22.

Belloni, A., V. Chernozhukov, C. Hansen and D. Kozbur (2016). "Inference in high dimensional panel
models with an application to gun control", \emph{Journal of Business & Economic Statistics}, 34, 590-605.
}

\examples{
\dontrun{
# First, we need to transform the data (this is what mlfitppml handles internally). Start by
# filtering the data set to keep only countries in the Americas:
americas <- countries$iso[countries$region == "Americas"]
trade <- trade[(trade$imp \%in\% americas) & (trade$exp \%in\% americas), ]
# Now generate the needed x, y and fes objects:
y <- trade$export
x <- data.matrix(trade[, -1:-6])
fes <- list(exp_time = interaction(trade$exp, trade$time),
            imp_time = interaction(trade$imp, trade$time),
            pair     = interaction(trade$exp, trade$imp))
# Finally, we try mlfitppml_int with a lasso penalty (the default) and two lambda values:
reg <- mlfitppml_int(y = y, x = x, fes = fes, lambdas = c(0.1, 0.01))

# We can also try plugin lasso:
\donttest{reg <- mlfitppml_int(y = y, x = x, fes = fes, cluster = fes$pair, method = "plugin")}

# For an example with cross-validation, please see the vignette.
}

}
