% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_ped.R
\name{convert_ped}
\alias{convert_ped}
\title{Converts a pedigree with individuals specified as factors to a numeric
pedigree}
\usage{
convert_ped(type = "numeric", id, sire, dam, missingVal = NA, key = NULL)
}
\arguments{
\item{type}{define how to convert the pedigree so "numeric" or "factor"}

\item{id}{Individual identifiers - pass using \code{as.character()}}

\item{sire}{Sire codes - pass \code{using as.character()}}

\item{dam}{Dam codes - pass \code{using as.character()}}

\item{missingVal}{the indicator that should be substituted for missing values}

\item{key}{A dataframe, as produced by \code{convert_ped}, specifying factor codes for numeric values in id, sire, and dam}
}
\value{
\item{numericPedigree}{The factor pedigree in numeric form}
\item{idKey}{A key to facilitate conversion back to the original
identifiers}
}
\description{
Some internal \code{pedtricks} modules require that pedigrees be
specified only by numerical values, or including numerical values
for missing data. This function provides the conversion to numeric but also
back to factors if needed
}
\examples{
pedigree <- as.data.frame(matrix(c(
  "m1",   NA,     NA,
  "m2",   NA,     NA,
  "m3",   NA,     NA,
  "d4",   NA,     NA,
  "d5",   NA,     NA,
  "o6",   "m1",   "d4",
  "o7",   "m1",   "d4",
  "o8",   "m1",   "d4",
  "o9",   "m1",   "d4",
  "o10",  "m2",   "d5",
  "o11",  "m2",   "d5",
  "o12",  "m2",   "d5",
  "o13",  "m2",   "d5",
  "o14",  "m3",   "d5",
  "o15",  "m3",   "d5",
  "o16",  "m3",   "d5",
  "o17",  "m3",   "d5"
), 17, 3, byrow = TRUE))
names(pedigree) <- c("id", "dam", "sire")
for (x in 1:3) pedigree[, x] <- as.factor(pedigree[, x])

## make the test pedigree numeric with NAs denoted by -1
convert_ped(
  type = "numeric",
  id = as.character(pedigree[, 1]),
  dam = as.character(pedigree[, 2]),
  sire = as.character(pedigree[, 3]),
  missingVal = -1
)
}
\keyword{manipulation}
