% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_plot.R
\name{plot.ped}
\alias{plot.ped}
\alias{plot.singleton}
\alias{as_kinship2_pedigree}
\alias{plot.pedList}
\title{Plot pedigrees with genotypes}
\usage{
\method{plot}{ped}(
  x,
  marker = NULL,
  sep = "/",
  missing = "-",
  showEmpty = FALSE,
  labs = labels(x),
  title = NULL,
  col = 1,
  aff = NULL,
  carrier = NULL,
  hatched = NULL,
  shaded = NULL,
  deceased = NULL,
  starred = NULL,
  twins = NULL,
  textInside = NULL,
  textAbove = NULL,
  hints = NULL,
  fouInb = "autosomal",
  margins = c(0.6, 1, 4.1, 1),
  keep.par = FALSE,
  ...
)

\method{plot}{singleton}(
  x,
  marker = NULL,
  sep = "/",
  missing = "-",
  showEmpty = FALSE,
  labs = labels(x),
  title = NULL,
  col = 1,
  aff = NULL,
  carrier = NULL,
  hatched = NULL,
  shaded = NULL,
  deceased = NULL,
  starred = NULL,
  textInside = NULL,
  textAbove = NULL,
  fouInb = "autosomal",
  margins = c(8, 0, 0, 0),
  yadj = 0,
  ...
)

as_kinship2_pedigree(
  x,
  deceased = NULL,
  aff = NULL,
  twins = NULL,
  hints = NULL
)

\method{plot}{pedList}(x, ...)
}
\arguments{
\item{x}{A \code{\link[=ped]{ped()}} object.}

\item{marker}{Either a vector of names or indices referring to markers
attached to \code{x}, a \code{marker} object, or a list of such. The genotypes for
the chosen markers are written below each individual in the pedigree, in
the format determined by \code{sep} and \code{missing}. See also \code{showEmpty}. If NULL
(the default), no genotypes are plotted.}

\item{sep}{A character of length 1 separating alleles for diploid markers.}

\item{missing}{The symbol (integer or character) for missing alleles.}

\item{showEmpty}{A logical, indicating if empty genotypes should be included.}

\item{labs}{A vector or function controlling the individual labels included
in the plot. Alternative forms:
\itemize{
\item If \code{labs} is a vector with nonempty intersection with \code{labels(x)}, these
individuals will be labelled. If the vector is named, then the (non-empty)
names are used instead of the ID label. (See Examples.)
\item If \code{labs} is NULL, or has nonempty intersection with \code{labels(x)}, then no
labels are drawn.
\item If \code{labs} is the word "num", then all individuals are numerically
labelled following the internal ordering.
\item If \code{labs} is a function, it will be replaced with \code{labs(x)} and handled
as above. (See Examples.)
}}

\item{title}{The plot title. If NULL (default) or '', no title is added to
the plot.}

\item{col}{A vector of colours for the pedigree members, recycled if
necessary. Alternatively, \code{col} can be a list assigning colours to specific
members. For example if \code{col = list(red = "a", blue = c("b", "c"))} then
individual "a" will be red, "b" and "c" blue, and everyone else black. By
default everyone is black.}

\item{aff}{A vector of labels identifying members whose plot symbols should
be filled. (This is typically used in medical pedigrees to indicate
affected members.)}

\item{carrier}{A vector of labels identifying members whose plot symbols
should be marked with a dot. (This is typically used in medical pedigrees
to indicate unaffected carriers of the disease allele.)}

\item{hatched}{A vector of labels identifying members whose plot symbols
should be hatched.}

\item{shaded}{(Deprecated) synonym of \code{hatched}}

\item{deceased}{A vector of labels indicating deceased pedigree members.}

\item{starred}{A vector of labels indicating pedigree members that should be
marked with a star in the pedigree plot.}

\item{twins}{A data frame with columns \code{id1}, \code{id2} and \code{code}, passed on to
the \code{relation} parameter of \code{\link[kinship2:plot.pedigree]{kinship2::plot.pedigree()}}.}

\item{textInside, textAbove}{Character vectors of text to be printed inside or
above pedigree symbols.}

\item{hints}{A list with alignment hints passed on to
\code{kinship2::align.pedigree()}. Rarely necessary, but see Examples.}

\item{fouInb}{Either "autosomal" (default), "x" or NULL. If "autosomal" or
"x", inbreeding coefficients are added to the plot above the inbred
founders. If NULL, or if no founders are inbred, nothing is added.}

\item{margins}{A numeric of length 4 indicating the plot margins. For
singletons only the first element (the 'bottom' margin) is used.}

\item{keep.par}{A logical (default = FALSE). If TRUE, the graphical
parameters are not reset after plotting, which may be useful for adding
additional annotation.}

\item{\dots}{Arguments passed on to \code{plot.pedigree} in the \code{kinship2}
package. In particular \code{symbolsize} and \code{cex} can be useful.}

\item{yadj}{A tiny adjustment sometimes needed to fix the appearance of
singletons.}
}
\description{
This is the main function for pedigree plotting, with many options for
controlling the appearance of pedigree symbols and accompanying labels. Most
of the work is done by the plotting functionality in the \code{kinship2} package.
}
\details{
\code{plot.ped} is in essence an elaborate wrapper for
\code{\link[kinship2:plot.pedigree]{kinship2::plot.pedigree()}}.
}
\examples{

x = nuclearPed(father = "fa", mother = "mo", child = "boy")
m = marker(x, fa = "1/1", boy = "1/2", name = "SNP")

plot(x, marker = m)

# Markers attached to `x` may be called by name
x = setMarkers(x, m)
plot(x, marker = "SNP")

# Other options
plot(x, marker = "SNP", hatched = typedMembers(x),
     starred = "fa", deceased = "mo")

# Filled symbols
plot(x, aff = males(x))

# Label only some members
plot(x, labs = c("fa", "boy"))

# Label only some members; rename the father
plot(x, labs = c(FATHER = "fa", "boy"))

# Label males only
plot(x, labs = males)

# Colours
plot(x, col = list(red = "fa", green = "boy"), hatched = "boy")

# Founder inbreeding is shown by default
founderInbreeding(x, "mo") = 0.1
plot(x)

# ... but can be suppressed
plot(x, fouInb = NULL)

# Twins
x = nuclearPed(children = c("tw1", "tw2", "tw3"))
plot(x, twins = data.frame(id1 = "tw1", id2 = "tw2", code = 1)) # MZ
plot(x, twins = data.frame(id1 = "tw1", id2 = "tw2", code = 1)) # DZ

# Triplets
plot(x, twins = data.frame(id1 = c("tw1", "tw2"),
                           id2 = c("tw2", "tw3"),
                           code = 2))

#-----------------------------
# In some cases, the plotting machinery of `kinship2` needs a hint
# (see ?kinship2::align.pedigree)

# Example with 3/4-siblings
y = nuclearPed(2)
y = addChildren(y, 3, mother = 5, nch = 1)
y = addChildren(y, 4, mother = 5, nch = 1)

plot(y) # bad

hints = list(order = 1:7, spouse = rbind(c(3,5,0), c(5,4,0)))
plot(y, hints = hints) # good

}
\seealso{
\code{\link[kinship2:plot.pedigree]{kinship2::plot.pedigree()}}
}
\author{
Magnus Dehli Vigeland
}
