% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_attach.R
\name{marker_attach}
\alias{marker_attach}
\alias{setMarkers}
\alias{addMarkers}
\title{Attach markers to pedigrees}
\usage{
setMarkers(x, m = NULL, alleleMatrix = NULL, locusAttributes = NULL,
  missing = 0, sep = NULL, ...)

addMarkers(x, m = NULL, alleleMatrix = NULL, locusAttributes = NULL,
  missing = 0, sep = NULL, ...)
}
\arguments{
\item{x}{A \code{ped} object}

\item{m}{Either a single \code{marker} object or a list of \code{marker} objects}

\item{alleleMatrix}{A matrix with \code{pedsize(x)} rows, containing the observed
alleles for one or several markers. The matrix must have either 1 or 2
columns per marker. If the former, then a \code{sep} string must be a given, and
will be used to split all entries.}

\item{locusAttributes}{A list of lists, with attributes for each marker. See
Details for possible attributes.}

\item{missing}{A single character (or coercible to one) indicating the symbol
for missing alleles.}

\item{sep}{If this is a single string, each entry of \code{alleleMatrix} is
interpreted as a genotype, and will be split by calling \code{strsplit(..., split = sep, fixed = T)}. For example, if the entries are formatted as
"A/B", put \code{sep = "/"}. Default: NULL.}

\item{...}{Further arguments}
}
\value{
A \code{ped} object.
}
\description{
In many applications it is useful to \emph{attach} markers to their associated
\code{ped} object. In particular for bigger projects with many markers, this makes
it easier to manipulate the dataset as a unit. The function \code{setMarkers()}
replaces all existing markers with the supplied ones, while \code{addMarkers()}
appends the supplied markers to any existing ones.
}
\details{
The most general format of \code{locusAttributes} a list of lists, one for each
marker, where possible entries in the inner lists are as follows (default
values in parenthesis):
\itemize{
\item \code{alleles} : a character vector with allele labels
\item \code{afreq} :  a numeric vector with allele frequencies (\code{rep.int(1/L, L)},
where \code{L = length(alleles)})
\item \code{chrom} : chromosome number (NA)
\item \code{posMb} : physical location in megabases (NA)
\item \code{posCm} : position in centiMorgan (NA)
\item \code{name} : marker name (NA)
\item \code{mutmod} : mutation model, or model name (NULL)
\item \code{rate} : mutation model parameter (NULL)
}

If \code{locusAttributes} is just a single list of attributes (not a list of
lists), then it is repeated to match the number of markers.

Two alternative format of \code{locusAttributes} are allowed: If a data.frame or
matrix is given, an attempt is made to interpret it as a frequency database
in \code{allelic ladder} format. Such an interpretation is also attempted if
\code{locusAttributes} is a list of named frequency vectors (where the names are
the allele labels).
}
\examples{
x = singleton(1)
m1 = marker(x, '1' = 1:2)
m2 = marker(x, '1' = 'a')

x = setMarkers(x, m1)
x = addMarkers(x, m2)
x

# Reversing the order of the markers
x = setMarkers(x, list(m2, m1))
x

}
