% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_locusattributes.R
\name{locusAttributes}
\alias{locusAttributes}
\alias{getLocusAttributes}
\alias{setLocusAttributes}
\title{Get or set locus attributes}
\usage{
getLocusAttributes(x, markers = NULL, attribs = c("alleles", "afreq",
  "name", "chrom", "posMb", "posCm", "mutmod"))

setLocusAttributes(x, markers = NULL, locusAttributes, matchNames = NA,
  erase = F)
}
\arguments{
\item{x}{A \code{ped} object, or a list of such.}

\item{markers}{A character vector (with marker names) or a numeric vector
(with marker indices). If NULL (default), the behaviour depends on
\code{matchNames}, see Details.}

\item{attribs}{A subset of the character vector \code{c("alleles", "afreq", "name" ,"chrom" ,"posMb","posCm", "mutmod", "rate")}.}

\item{locusAttributes}{A list of lists, with attributes for each marker.}

\item{matchNames}{A logical, only relevant if \code{markers = NULL}. If TRUE, then
the markers to be modified are identified by the 'name' component of each
\code{locusAttributes} entry. If FALSE, all markers attached to \code{x} are selected
in order.}

\item{erase}{A logical. If TRUE, all previous attributes of the selected
markers are erased. If FALSE, attributes not affected by the submitted
\code{locusAttributes} remain untouched.}
}
\value{
\itemize{
\item \code{getLocusAttributes} : a list of lists
\item \code{setLocusAttributes} : a modified version of \code{x}.
}
}
\description{
Retrieve or modify the attributes of attached markers
}
\details{
The default setting \code{markers = NULL} select markers automatically, depending
on the \code{matchNames} argument. If \code{matchNames = FALSE}, all markers are chosen
If \code{matchNames = TRUE}, markers will be matched against the \code{name} entries in
\code{locusAttributes} (and an error issued if these are missing).

Note that the default value \code{NA} of \code{matchNames} is changed to TRUE if all
entries of \code{locusAttributes} have a \code{name} component which matches the name a
an attached marker.

Possible attributes given in \code{locusAttributes} are as follows (default values
in parenthesis):
\itemize{
\item \code{alleles} : a character vector with allele labels
\item \code{afreq} :  a numeric vector with allele frequencies (\code{rep.int(1/L, L)},
where \code{L = length(alleles)})
\item \code{name} : marker name (NA)
\item \code{chrom} : chromosome number (NA)
\item \code{posMb} : physical location in megabases (NA)
\item \code{posCm} : position in centiMorgan (NA)
\item \code{mutmod} : mutation model, or model name (NULL)
\item \code{rate} : mutation model parameter (NULL)
}
}
\examples{
x = singleton(1)
x = addMarkers(x, marker(x, name = "m1", alleles = 1:2))
x = addMarkers(x, marker(x, name = "m2", alleles = letters[1:2], chrom = "X"))

# Change frequencies at both loci
y = setLocusAttributes(x, markers = 1:2, loc = list(afreq = c(.1, .9)))
getMarkers(y, 1)

# Set the same mutation model at both loci
z = setLocusAttributes(x, markers = 1:2, loc = list(mutmod = "proportional", rate = .1))
mutmod(z, 1)

# By default, the markers to be modified are identified by name
locs = list(list(name = "m1", alleles = 1:10),
            list(name = "m2", alleles = letters[1:10]))
w = setLocusAttributes(x, loc = locs)
getMarkers(w, 1:2)

# If `erase = T` attributes not explicitly given are erased
w2 = setLocusAttributes(x, loc = locs, erase = TRUE)
chrom(w2, 2) # not "X" anymore

# The getter and setter are inverses
newx = setLocusAttributes(x, loc = getLocusAttributes(x))
stopifnot(identical(x, newx))

}
