\name{ps_ouss}
\alias{ps_ouss}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Power spectrum of the OUSS process
}
\description{
Returns the power spectrum of the Ornstein-Uhlenbeck state space (OUSS) process at a particular frequency. This is the same as the asymptotic expected periodogram power for long regular time series.
}
\usage{
ps_ouss(freq, power_o, lambda, power_e, time_step)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{freq}{
    Single number or numeric vector. The frequency for which to the power spectrum is to be calculated.
}
  \item{power_o}{
    Single number. Power at zero-frequency generated by the underlying OU process.
}
  \item{lambda}{
    Single number. Resilience (or relaxation rate) of the OU process. This is also the inverse correlation time of the OU process. 
}
  \item{power_e}{
    Single number. Asymptotic power at large frequencies due to the random measurement errors. Setting this to zero corresponds to the classical OU process.
}
  \item{time_step}{
    Positive number. The time step of the time series that was (or will be) used for periodogram generation.
}
}
\details{
The OUSS parameters \code{power_o}, \code{lambda} and \code{power_e} will typically be maximum-likelihood fitted values returned by \code{\link{evaluate.pm}}. \code{time_step} is also returned by \code{\link{evaluate.pm}} and is inferred from the analysed time series. More generally, \code{power_o} and \code{power_e} are proportional to the OUSS parameters \eqn{\sigma^2} and \eqn{\epsilon^2} (see \code{\link{generate_ouss}}), respectively, but the exact scaling depends on the normalization used for the periodogram.
}
\value{
Returns a numeric vector of the same size as \code{freq}, containing the corresponding powers of the OUSS process.
}
\references{
Louca, S., Doebeli, M. - Detecting cyclicity in ecological time series (in review, as of June 2014)
}
\author{
Stilianos Louca
}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{evaluate.pm}}, \code{\link{generate_ouss}}
}
\examples{
# generate OUSS time series
times  = seq(0,20,0.2);
signal = generate_ouss(times, mu=0, sigma=1, lambda=1, epsilon=0.5);

# calculate periodogram and fit OUSS model
report = evaluate.pm(times=times, signal=signal);

# plot periodogram
plot(report$frequencies, report$periodogram, 
     type="l", ylab="power", xlab="frequency", main="periodogram & fitted OUSS power spectrum");

# plot fitted OUSS spectrum
lines(report$frequencies, 
      ps_ouss(freq=report$frequencies, 
              power_o=report$power_o, 
              lambda=report$lambda, 
              power_e=report$power_e, 
              time_step=report$time_step), 
      col="red");

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
