% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gw_sdp_gdp}
\alias{gw_sdp_gdp}
\title{(Surplus and Gross) Domestic Product for Gleditsch-Ward States}
\format{
A data frame with 27387 observations on the following five variables.
\describe{
\item{\code{gwcode}}{a numeric vector for the Gleditsch-Ward state code}
\item{\code{year}}{a numeric vector for the year}
\item{\code{wbgdp2011est}}{a numeric vector for the estimated natural log of GDP in 2011 USD (log-transformed)}
\item{\code{wbpopest}}{a numeric vector for the estimated population size (log-transformed)}
\item{\code{sdpest}}{a numeric vector for the estimated surplus domestic product (log-transformed)}
\item{\code{wbgdppc2011est}}{a numeric vector for the estimated GDP per capita (log-transformed)}
}
}
\usage{
gw_sdp_gdp
}
\description{
These are state-year level data for surplus and gross domestic product for Correlates of War state system members. Data also
include population estimates for per capita standardization.
}
\details{
These were provided by Anders on a separate Github repository for this project. Because these
data are ultimately being simulated, a user can expect some slight differences between the Correlates of War version of these data
(which Anders et al. published) and the Gleditsch-Ward version of these data (which appear to be the one the authors will more
vigorously support going forward).
}
\references{
Anders, Therese, Christopher J. Fariss, and Jonathan N. Markowitz. 2020. "Bread Before Guns or Butter: Introducing Surplus Domestic Product (SDP)"
\emph{International Studies Quarterly} 64(2): 392--405.
}
\keyword{datasets}
